/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity;

import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuardianCrystalRenderer
extends EntityRenderer<GuardianCrystalEntity> {
    private static ResourceLocation ENDER_CRYSTAL_TEXTURES = new ResourceLocation("draconicevolution", "textures/entity/guardian_crystal.png");
    private static RenderType RENDER_TYPE = RenderType.func_228640_c_((ResourceLocation)ENDER_CRYSTAL_TEXTURES);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelRenderer cube;
    private final ModelRenderer glass;
    private final ModelRenderer base;

    public GuardianCrystalRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.5f;
        this.glass = new ModelRenderer(64, 32, 0, 0);
        this.glass.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.cube = new ModelRenderer(64, 32, 32, 0);
        this.cube.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.base = new ModelRenderer(64, 32, 0, 16);
        this.base.func_228300_a_(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f);
    }

    public void render(GuardianCrystalEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer getter, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        float yBob = GuardianCrystalRenderer.getY(entityIn, partialTicks);
        float f1 = ((float)entityIn.innerRotation + partialTicks) * 3.0f;
        IVertexBuilder ivertexbuilder = getter.getBuffer(RENDER_TYPE);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(2.0f, 2.0f, 2.0f);
        matrixStackIn.func_227861_a_(0.0, -0.5, 0.0);
        int i = OverlayTexture.field_229196_a_;
        if (entityIn.shouldShowBottom()) {
            this.base.func_228308_a_(matrixStackIn, ivertexbuilder, packedLightIn, i);
        }
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
        matrixStackIn.func_227861_a_(0.0, (double)(1.5f + yBob / 2.0f), 0.0);
        matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        this.glass.func_228308_a_(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.func_227862_a_(0.875f, 0.875f, 0.875f);
        matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
        this.glass.func_228308_a_(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.func_227862_a_(0.875f, 0.875f, 0.875f);
        matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
        this.cube.func_228308_a_(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.func_227865_b_();
        float shieldPower = entityIn.getShieldPower() / (float)Math.max(20, DEConfig.guardianCrystalShield);
        if (shieldPower > 0.0f) {
            UniformCache uniforms = DraconicGuardianRenderer.shieldShader.pushCache();
            uniforms.glUniform4f("baseColour", 1.0f, 0.0f, 0.0f, 1.5f * shieldPower);
            IVertexBuilder shaderBuilder = getter.getBuffer((RenderType)new ShaderRenderType(DraconicGuardianRenderer.shieldType, DraconicGuardianRenderer.shieldShader, uniforms));
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(2.0f, 2.0f, 2.0f);
            matrixStackIn.func_227861_a_(0.0, -0.5, 0.0);
            if (entityIn.shouldShowBottom()) {
                this.base.func_228308_a_(matrixStackIn, shaderBuilder, packedLightIn, i);
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            matrixStackIn.func_227861_a_(0.0, (double)(1.5f + yBob / 2.0f), 0.0);
            matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            this.glass.func_228308_a_(matrixStackIn, shaderBuilder, packedLightIn, i);
            matrixStackIn.func_227862_a_(0.875f, 0.875f, 0.875f);
            matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            this.glass.func_228308_a_(matrixStackIn, shaderBuilder, packedLightIn, i);
            matrixStackIn.func_227862_a_(0.875f, 0.875f, 0.875f);
            matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            this.cube.func_228308_a_(matrixStackIn, shaderBuilder, packedLightIn, i);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        BlockPos blockpos = entityIn.getBeamTarget();
        if (blockpos != null) {
            float posX = (float)blockpos.func_177958_n() + 0.5f;
            float posY = (float)blockpos.func_177956_o() + 0.5f;
            float posZ = (float)blockpos.func_177952_p() + 0.5f;
            float relX = (float)((double)posX - entityIn.func_226277_ct_());
            float relY = (float)((double)posY - entityIn.func_226278_cu_());
            float relZ = (float)((double)posZ - entityIn.func_226281_cx_());
            matrixStackIn.func_227861_a_((double)relX, (double)(relY - 2.0f), (double)relZ);
            float beamPower = entityIn.getBeamPower();
            if (beamPower < 1.0f) {
                DraconicGuardianRenderer.renderBeam(-relX, -relY + yBob + 2.0f, -relZ, partialTicks, entityIn.innerRotation, matrixStackIn, getter, packedLightIn, beamPower);
            } else {
                DraconicGuardianRenderer.renderBeam(-relX, -relY + yBob + 2.0f, -relZ, partialTicks, entityIn.innerRotation, matrixStackIn, getter, packedLightIn);
            }
        }
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, getter, packedLightIn);
    }

    public static float getY(GuardianCrystalEntity p_229051_0_, float p_229051_1_) {
        float f = (float)p_229051_0_.innerRotation + p_229051_1_;
        float f1 = MathHelper.func_76126_a((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    public ResourceLocation getTextureLocation(GuardianCrystalEntity entity) {
        return ENDER_CRYSTAL_TEXTURES;
    }

    public boolean shouldRender(GuardianCrystalEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        return super.func_225626_a_((Entity)livingEntityIn, camera, camX, camY, camZ) || livingEntityIn.getBeamTarget() != null;
    }
}

