/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.utils.ResourceHelperDE;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class CrystalFXLink
extends CrystalFXBase<TileCrystalBase> {
    private final Vec3D linkTarget;
    private final boolean terminateSource;
    private final boolean terminateTarget;
    public int timeout = 0;
    private static final IParticleRenderType HANDLER = new FXHandler();

    public CrystalFXLink(ClientWorld worldIn, TileCrystalBase tile, Vec3D linkTarget) {
        super(worldIn, tile);
        Direction face;
        this.field_70546_d = worldIn.field_73012_v.nextInt(1024);
        this.setPosition(tile.getBeamLinkPos(linkTarget.getPos()));
        this.terminateSource = true;
        this.linkTarget = linkTarget;
        Direction direction = face = tile instanceof TileCrystalWirelessIO ? ((TileCrystalWirelessIO)tile).getReceiversFaces().get(linkTarget.getPos()) : null;
        if (face != null) {
            linkTarget.add((double)face.func_82601_c() * 0.6, (double)face.func_96559_d() * 0.6, (double)face.func_82599_e() * 0.6);
        }
        this.terminateTarget = true;
        this.func_187108_a(new AxisAlignedBB(this.field_187126_f, this.field_187127_g, this.field_187128_h, this.linkTarget.x, this.linkTarget.y, this.linkTarget.z));
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        if (!ClientEventHandler.playerHoldingWrench && this.timeout <= 0) {
            this.func_187112_i();
        } else if (this.timeout > 0) {
            --this.timeout;
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3f[] renderVector;
        float viewZ;
        float viewY;
        float viewX;
        float scale = 0.1f + (float)this.timeout * 0.005f;
        Vector3d viewVec = renderInfo.func_216785_c();
        Vector3 source = new Vector3(this.field_187126_f - viewVec.field_72450_a, this.field_187127_g - viewVec.field_72448_b, this.field_187128_h - viewVec.field_72449_c);
        Vector3 target = this.linkTarget.toVector3().subtract(viewVec.field_72450_a, viewVec.field_72448_b, viewVec.field_72449_c);
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply((double)scale);
        planeB.multiply((double)scale);
        planeC.multiply((double)scale);
        planeD.multiply((double)scale);
        float dist = 0.2f * (float)Utils.getDistanceAtoB((Vec3D)new Vec3D(source), (Vec3D)new Vec3D(target));
        float anim = ((float)ClientEventHandler.elapsedTicks + partialTicks) / -15.0f;
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        scale *= 2.0f;
        float minU = 0.0f;
        float maxU = 0.53f;
        float minV = 0.0f;
        float maxV = 0.53f;
        if (this.terminateSource) {
            viewX = (float)(this.field_187126_f - viewVec.func_82615_a());
            viewY = (float)(this.field_187127_g - viewVec.func_82617_b());
            viewZ = (float)(this.field_187128_h - viewVec.func_82616_c());
            renderVector = this.getRenderVectors(renderInfo, viewX, viewY, viewZ, scale);
            buffer.func_225582_a_((double)renderVector[0].func_195899_a(), (double)renderVector[0].func_195900_b(), (double)renderVector[0].func_195902_c()).func_225583_a_(maxU, maxV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[1].func_195899_a(), (double)renderVector[1].func_195900_b(), (double)renderVector[1].func_195902_c()).func_225583_a_(maxU, minV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[2].func_195899_a(), (double)renderVector[2].func_195900_b(), (double)renderVector[2].func_195902_c()).func_225583_a_(minU, minV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[3].func_195899_a(), (double)renderVector[3].func_195900_b(), (double)renderVector[3].func_195902_c()).func_225583_a_(minU, maxV).func_181675_d();
        }
        if (this.terminateTarget) {
            viewX = (float)(this.linkTarget.x - viewVec.func_82615_a());
            viewY = (float)(this.linkTarget.y - viewVec.func_82617_b());
            viewZ = (float)(this.linkTarget.z - viewVec.func_82616_c());
            renderVector = this.getRenderVectors(renderInfo, viewX, viewY, viewZ, scale);
            buffer.func_225582_a_((double)renderVector[0].func_195899_a(), (double)renderVector[0].func_195900_b(), (double)renderVector[0].func_195902_c()).func_225583_a_(maxU, maxV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[1].func_195899_a(), (double)renderVector[1].func_195900_b(), (double)renderVector[1].func_195902_c()).func_225583_a_(maxU, minV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[2].func_195899_a(), (double)renderVector[2].func_195900_b(), (double)renderVector[2].func_195902_c()).func_225583_a_(minU, minV).func_181675_d();
            buffer.func_225582_a_((double)renderVector[3].func_195899_a(), (double)renderVector[3].func_195900_b(), (double)renderVector[3].func_195902_c()).func_225583_a_(minU, maxV).func_181675_d();
        }
    }

    private void bufferQuad(IVertexBuilder buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, float anim, float dist) {
        buffer.func_225582_a_(p1.x, p1.y, p1.z).func_225583_a_(0.5f, anim).func_181675_d();
        buffer.func_225582_a_(p2.x, p2.y, p2.z).func_225583_a_(0.5f, dist + anim).func_181675_d();
        buffer.func_225582_a_(p4.x, p4.y, p4.z).func_225583_a_(1.0f, dist + anim).func_181675_d();
        buffer.func_225582_a_(p3.x, p3.y, p3.z).func_225583_a_(1.0f, anim).func_181675_d();
    }

    public IParticleRenderType func_217558_b() {
        return HANDLER;
    }

    public static class FXHandler
    implements IParticleRenderType {
        public void func_217600_a(BufferBuilder builder, TextureManager p_217600_2_) {
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
            ResourceHelperDE.bindTexture("textures/particle/energy_beam_basic.png");
            RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }
}

