/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.EnumProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.inventory.ContainerConfigurableItem;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class PropertyData {
    public final ConfigProperty.Type type;
    public final UUID providerID;
    public final String providerName;
    private String propName;
    protected UUID propUniqueName;
    public String toolTip;
    public String displayName;
    public Runnable changeListener;
    public boolean isGlobal = false;
    private boolean isPropertyAvailable = false;
    public boolean isProviderAvailable = false;
    public int integerValue = 0;
    public double decimalValue = 0.0;
    public String displayValue = "value";
    public boolean booleanValue = false;
    public double minValue = 0.0;
    public double maxValue = 1.0;
    public ConfigProperty.BooleanFormatter booleanFormatter = ConfigProperty.BooleanFormatter.TRUE_FALSE;
    public ConfigProperty.IntegerFormatter integerFormatter = ConfigProperty.IntegerFormatter.RAW;
    public ConfigProperty.DecimalFormatter decimalFormatter = ConfigProperty.DecimalFormatter.RAW_1;
    public int enumValueIndex = 0;
    public List<Integer> enumValueOptions;
    public Map<Integer, String> enumDisplayValues;

    public PropertyData(PropertyProvider provider, ConfigProperty property, boolean pullValue) {
        this(provider.getProviderID(), provider.getProviderName(), property.getType());
        this.displayName = property.getDisplayName().getString();
        this.toolTip = property.getToolTip().getString();
        if (property.getUniqueName() != null) {
            this.propUniqueName = property.getUniqueName();
        } else {
            this.propName = property.getName();
        }
        this.isProviderAvailable = true;
        this.pullData(property, pullValue);
    }

    public PropertyData(UUID providerID, String providerName, ConfigProperty.Type type) {
        this.providerID = providerID;
        this.providerName = providerName;
        this.type = type;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void pullData(ConfigProperty property, boolean pullValue) {
        boolean bl = this.isPropertyAvailable = property != null;
        if (this.isPropertyAvailable) {
            this.displayName = property.getDisplayName().getString();
            ITextComponent component = property.getToolTip();
            this.toolTip = component.getString();
            if (component instanceof TranslationTextComponent && ((TranslationTextComponent)component).func_150268_i().equals(this.toolTip)) {
                this.toolTip = "";
            }
            this.displayValue = property.getDisplayValue();
            switch (property.getType()) {
                case BOOLEAN: {
                    BooleanProperty prop = (BooleanProperty)property;
                    this.booleanFormatter = prop.getFormatter();
                    if (!pullValue) break;
                    this.booleanValue = prop.getValue();
                    break;
                }
                case INTEGER: {
                    IntegerProperty prop = (IntegerProperty)property;
                    this.integerFormatter = prop.getFormatter();
                    this.minValue = prop.getMin();
                    this.maxValue = prop.getMax();
                    if (!pullValue) break;
                    this.integerValue = prop.getValue();
                    break;
                }
                case DECIMAL: {
                    DecimalProperty prop = (DecimalProperty)property;
                    this.decimalFormatter = prop.getFormatter();
                    this.minValue = prop.getMin();
                    this.maxValue = prop.getMax();
                    if (!pullValue) break;
                    this.decimalValue = prop.getValue();
                    break;
                }
                case ENUM: {
                    EnumProperty prop = (EnumProperty)property;
                    this.enumValueOptions = prop.getAllowedValues().stream().map(Enum::ordinal).collect(Collectors.toList());
                    this.enumDisplayValues = prop.generateValueDisplayMap();
                    if (!pullValue) break;
                    this.enumValueIndex = ((Enum)prop.getValue()).ordinal();
                    break;
                }
            }
        }
        this.updateDisplayValue();
    }

    public String getPropertyName() {
        return this.propUniqueName == null ? this.propName : this.propUniqueName.toString();
    }

    public void pullData(ContainerConfigurableItem container, boolean pullValue) {
        PropertyProvider provider = container.findProvider(this.providerID);
        boolean bl = this.isProviderAvailable = provider != null;
        if (this.isProviderAvailable) {
            this.pullData(provider.getProperty(this.getPropertyName()), pullValue);
        }
    }

    public void updateDisplayValue() {
        switch (this.type) {
            case BOOLEAN: {
                if (this.booleanFormatter == null) break;
                this.displayValue = this.booleanFormatter.format(this.booleanValue);
                break;
            }
            case INTEGER: {
                if (this.integerFormatter == null) break;
                this.displayValue = this.integerFormatter.format(this.integerValue);
                break;
            }
            case DECIMAL: {
                if (this.decimalFormatter == null) break;
                this.displayValue = this.decimalFormatter.format(this.decimalValue);
                break;
            }
            case ENUM: {
                if (this.enumDisplayValues == null) break;
                this.displayValue = this.enumDisplayValues.getOrDefault(this.enumValueIndex, "[Error]");
            }
        }
    }

    public void updateBooleanValue(boolean newValue) {
        if (this.type == ConfigProperty.Type.BOOLEAN) {
            this.booleanValue = newValue;
            this.updateDisplayValue();
            this.onValueChanged();
        }
    }

    public void toggleBooleanValue() {
        this.updateBooleanValue(!this.booleanValue);
    }

    public void updateEnumValue(int newIndex) {
        if (this.type == ConfigProperty.Type.ENUM && this.enumValueOptions.contains(newIndex)) {
            this.enumValueIndex = newIndex;
            this.updateDisplayValue();
            this.onValueChanged();
        }
    }

    public void updateNumberValue(double value, boolean isFinalValue) {
        if (this.type == ConfigProperty.Type.INTEGER) {
            this.integerValue = (int)Math.round(value);
        } else if (this.type == ConfigProperty.Type.DECIMAL) {
            this.decimalValue = value;
        } else {
            return;
        }
        this.updateDisplayValue();
        if (isFinalValue) {
            this.onValueChanged();
        }
    }

    public void increment(int dir) {
        if (this.type == ConfigProperty.Type.INTEGER) {
            int inc = (int)(Math.max(1.0, this.getInc(this.maxValue - this.minValue)) * (double)dir * (double)(Screen.func_231173_s_() ? 2 : 1));
            this.integerValue = (int)MathHelper.clip((double)(this.integerValue + inc), (double)this.minValue, (double)this.maxValue);
        } else if (this.type == ConfigProperty.Type.DECIMAL) {
            double inc = this.getInc(this.maxValue - this.minValue) * (double)dir * (double)(Screen.func_231173_s_() ? 2 : 1);
            this.decimalValue = MathHelper.clip((double)(this.decimalValue + inc), (double)this.minValue, (double)this.maxValue);
        } else if (this.type == ConfigProperty.Type.ENUM && this.enumValueOptions != null && this.enumValueOptions.contains(this.enumValueIndex)) {
            int index = this.enumValueOptions.indexOf(this.enumValueIndex);
            int newIndex = Math.floorMod(index + dir, this.enumValueOptions.size());
            this.enumValueIndex = this.enumValueOptions.get(newIndex);
        } else {
            return;
        }
        this.updateDisplayValue();
        this.onValueChanged();
    }

    private double getInc(double range) {
        if (range <= 1.0) {
            return 0.1;
        }
        if (range <= 5.0) {
            return 0.5;
        }
        if (range <= 10.0) {
            return 1.0;
        }
        if (range <= 20.0) {
            return 2.0;
        }
        if (range <= 50.0) {
            return 5.0;
        }
        return 10.0;
    }

    public void onValueChanged() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    public void toggleGlobal() {
        this.isGlobal = !this.isGlobal;
    }

    public String getEnumDisplayName(int enumIndex) {
        return this.enumDisplayValues != null && this.enumDisplayValues.containsKey(enumIndex) ? this.enumDisplayValues.get(enumIndex) : TextFormatting.RED + "[Error]";
    }

    public void sendToServer() {
        DraconicNetwork.sendPropertyData(this);
    }

    public ConfigProperty getPropIfApplicable(PropertyProvider provider) {
        if (provider.getProviderName().equals(this.providerName) && (this.isGlobal || provider.getProviderID().equals(this.providerID))) {
            return provider.getProperty(this.getPropertyName());
        }
        return null;
    }

    public boolean doesDataMatch(ConfigProperty prop) {
        switch (this.type) {
            case BOOLEAN: {
                return prop instanceof BooleanProperty && ((BooleanProperty)prop).getValue() == this.booleanValue;
            }
            case INTEGER: {
                return prop instanceof IntegerProperty && ((IntegerProperty)prop).getValue() == this.integerValue;
            }
            case DECIMAL: {
                return prop instanceof DecimalProperty && ((DecimalProperty)prop).getValue() == this.decimalValue;
            }
            case ENUM: {
                return prop instanceof EnumProperty && ((Enum)((EnumProperty)prop).getValue()).ordinal() == this.enumValueIndex;
            }
        }
        return false;
    }

    public boolean isPropertyAvailable() {
        return this.isPropertyAvailable && this.isProviderAvailable;
    }

    public PropertyData copy() {
        PropertyData copy = new PropertyData(this.providerID, this.providerName, this.type);
        copy.propName = this.propName;
        copy.propUniqueName = this.propUniqueName;
        copy.toolTip = this.toolTip;
        copy.displayName = this.displayName;
        copy.changeListener = this.changeListener;
        copy.isGlobal = this.isGlobal;
        copy.isPropertyAvailable = this.isPropertyAvailable;
        copy.isProviderAvailable = this.isProviderAvailable;
        copy.integerValue = this.integerValue;
        copy.decimalValue = this.decimalValue;
        copy.displayValue = this.displayValue;
        copy.booleanValue = this.booleanValue;
        copy.minValue = this.minValue;
        copy.maxValue = this.maxValue;
        copy.booleanFormatter = this.booleanFormatter;
        copy.integerFormatter = this.integerFormatter;
        copy.decimalFormatter = this.decimalFormatter;
        copy.enumValueIndex = this.enumValueIndex;
        if (this.enumValueOptions != null && this.enumDisplayValues != null) {
            copy.enumValueOptions = new ArrayList<Integer>(this.enumValueOptions);
            copy.enumDisplayValues = new HashMap<Integer, String>(this.enumDisplayValues);
        }
        return copy;
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74774_a("type", (byte)this.type.ordinal());
        nbt.func_186854_a("prov_id", this.providerID);
        nbt.func_74778_a("prov_name", this.providerName);
        if (this.propUniqueName != null) {
            nbt.func_186854_a("prop_name", this.propUniqueName);
        } else {
            nbt.func_74778_a("prop_name", this.propName);
        }
        nbt.func_74778_a("tooltip", this.toolTip);
        nbt.func_74778_a("display_name", this.displayName);
        nbt.func_74778_a("display_value", this.displayValue);
        nbt.func_74757_a("global", this.isGlobal);
        switch (this.type) {
            case BOOLEAN: {
                nbt.func_74757_a("value", this.booleanValue);
                nbt.func_74774_a("formatter", (byte)this.booleanFormatter.ordinal());
                break;
            }
            case INTEGER: {
                nbt.func_74768_a("value", this.integerValue);
                nbt.func_74774_a("formatter", (byte)this.integerFormatter.ordinal());
                nbt.func_74768_a("min", (int)this.minValue);
                nbt.func_74768_a("max", (int)this.maxValue);
                break;
            }
            case DECIMAL: {
                nbt.func_74780_a("value", this.decimalValue);
                nbt.func_74774_a("formatter", (byte)this.decimalFormatter.ordinal());
                nbt.func_74780_a("min", this.minValue);
                nbt.func_74780_a("max", this.maxValue);
                break;
            }
            case ENUM: {
                nbt.func_74768_a("value", this.enumValueIndex);
                if (this.enumValueOptions != null) {
                    nbt.func_218657_a("names", (INBT)this.enumValueOptions.stream().map(IntNBT::func_229692_a_).collect(Collectors.toCollection(ListNBT::new)));
                }
                if (this.enumDisplayValues == null) break;
                CompoundNBT nameValues = new CompoundNBT();
                this.enumDisplayValues.forEach((key, value) -> nameValues.func_74778_a(String.valueOf(key), value));
                nbt.func_218657_a("name_values", (INBT)nameValues);
            }
        }
        return nbt;
    }

    @Nullable
    public static PropertyData deserialize(CompoundNBT nbt) {
        if (!(nbt.func_186855_b("prov_id") && nbt.func_74764_b("prov_name") && (nbt.func_74764_b("prop_name") || nbt.func_186855_b("prop_name")) && nbt.func_74764_b("type"))) {
            return null;
        }
        PropertyData data = new PropertyData(nbt.func_186857_a("prov_id"), nbt.func_74779_i("prov_name"), ConfigProperty.Type.getSafe(nbt.func_74771_c("type")));
        if (nbt.func_186855_b("prop_name")) {
            data.propUniqueName = nbt.func_186857_a("prop_name");
        } else {
            data.propName = nbt.func_74779_i("prop_name");
        }
        data.toolTip = nbt.func_74779_i("tooltip");
        data.displayName = nbt.func_74779_i("display_name");
        data.displayValue = nbt.func_74779_i("display_value");
        data.isGlobal = nbt.func_74767_n("global");
        switch (data.type) {
            case BOOLEAN: {
                data.booleanValue = nbt.func_74767_n("value");
                data.booleanFormatter = ConfigProperty.BooleanFormatter.getSafe(nbt.func_74771_c("formatter"));
                break;
            }
            case INTEGER: {
                data.integerValue = nbt.func_74762_e("value");
                data.integerFormatter = ConfigProperty.IntegerFormatter.getSafe(nbt.func_74771_c("formatter"));
                data.minValue = nbt.func_74762_e("min");
                data.maxValue = nbt.func_74762_e("max");
                break;
            }
            case DECIMAL: {
                data.decimalValue = nbt.func_74769_h("value");
                data.decimalFormatter = ConfigProperty.DecimalFormatter.getSafe(nbt.func_74771_c("formatter"));
                data.minValue = nbt.func_74769_h("min");
                data.maxValue = nbt.func_74769_h("max");
                break;
            }
            case ENUM: {
                data.enumValueIndex = nbt.func_74762_e("value");
                if (nbt.func_74764_b("names")) {
                    data.enumValueOptions = nbt.func_150295_c("names", 3).stream().map(inbt -> ((IntNBT)inbt).func_150287_d()).collect(Collectors.toList());
                }
                if (!nbt.func_74764_b("name_values")) break;
                CompoundNBT nameValues = nbt.func_74775_l("name_values");
                data.enumDisplayValues = nameValues.func_150296_c().stream().collect(Collectors.toMap(Utils::parseInt, arg_0 -> ((CompoundNBT)nameValues).func_74779_i(arg_0)));
            }
        }
        return data;
    }

    public void write(MCDataOutput output) {
        output.writeEnum((Enum)this.type);
        output.writeBoolean(this.isGlobal);
        if (!this.isGlobal) {
            output.writeUUID(this.providerID);
        }
        output.writeString(this.providerName);
        output.writeBoolean(this.propUniqueName != null);
        if (this.propUniqueName != null) {
            output.writeUUID(this.propUniqueName);
        } else {
            output.writeString(this.propName);
        }
        if (this.type == ConfigProperty.Type.BOOLEAN) {
            output.writeBoolean(this.booleanValue);
        } else if (this.type == ConfigProperty.Type.INTEGER) {
            output.writeVarInt(this.integerValue);
        } else if (this.type == ConfigProperty.Type.DECIMAL) {
            output.writeDouble(this.decimalValue);
        } else if (this.type == ConfigProperty.Type.ENUM) {
            output.writeVarInt(this.enumValueIndex);
        }
    }

    public static PropertyData read(MCDataInput input) {
        ConfigProperty.Type type = (ConfigProperty.Type)input.readEnum(ConfigProperty.Type.class);
        boolean isGlobal = input.readBoolean();
        UUID provID = isGlobal ? null : input.readUUID();
        String provName = input.readString();
        PropertyData data = new PropertyData(provID, provName, type);
        if (input.readBoolean()) {
            data.propUniqueName = input.readUUID();
        } else {
            data.propName = input.readString();
        }
        data.isGlobal = isGlobal;
        if (type == ConfigProperty.Type.BOOLEAN) {
            data.booleanValue = input.readBoolean();
        } else if (type == ConfigProperty.Type.INTEGER) {
            data.integerValue = input.readVarInt();
        } else if (type == ConfigProperty.Type.DECIMAL) {
            data.decimalValue = input.readDouble();
        } else if (type == ConfigProperty.Type.ENUM) {
            data.enumValueIndex = input.readVarInt();
        }
        return data;
    }
}

