/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextCompLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TBasicMachine;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.lib.datamanager.ManagedTextComponent;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.inventory.ContainerFusionCraftingCore;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiFusionCraftingCore
extends ModularGuiContainer<ContainerFusionCraftingCore> {
    private final TileFusionCraftingCore tile;
    private IFusionRecipe currentRecipe = null;
    protected GuiToolkit<GuiFusionCraftingCore> toolkit = new GuiToolkit((Screen)this, 218, 220).setTranslationPrefix("gui.draconicevolution.fusion_craft");
    private GuiStackIcon stackIcon;

    public GuiFusionCraftingCore(ContainerFusionCraftingCore container, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)container, inv, titleIn);
        this.tile = (TileFusionCraftingCore)container.tile;
    }

    public void addElements(GuiElementManager manager) {
        TBasicMachine template = new TBasicMachine((Screen)this, (TileBCore)this.tile, false);
        template.background = GuiTexture.newDynamicTexture((int)this.xSize(), (int)this.ySize(), () -> BCSprites.getThemed((String)"background_dynamic"));
        template.background.onReload(guiTex -> guiTex.setPos(this.guiLeft(), this.guiTop()));
        this.toolkit.loadTemplate((IGuiTemplate)template);
        template.addPlayerSlots(true, true, true);
        GuiElement craftArea = template.background.addChild(new GuiElement());
        craftArea.setPos(template.background.xPos() + 17, template.title.maxYPos() + 3);
        craftArea.setMaxPos(template.background.maxXPos() - 17, template.playerSlots.yPos() - 3, true);
        GuiElement slots = this.toolkit.createSlots(template.background, 1, 2, 26, (x, y) -> ((ContainerFusionCraftingCore)this.container).getSlotLayout().getSlotData(ContainerSlotLayout.SlotType.TILE_INV, y.intValue()), null);
        this.toolkit.center(slots, craftArea, 0, 3);
        template.background.addChild((GuiElement)((GuiTextCompLabel)((GuiTextCompLabel)new GuiTextCompLabel().setPosAndSize(template.background.xPos() + template.background.xSize() / 2 - 40, template.title.maxYPos() + 4, 80, 20)).setAlignment(GuiAlign.CENTER).setTrim(false).setWrap(true).setShadow(true).setEnabledCallback(() -> this.tile.userStatus.get() != null)).setTextSupplier(() -> ((ManagedTextComponent)this.tile.userStatus).get()));
        ((GuiButton)((GuiButton)this.toolkit.createButton("gui.draconicevolution.fusion_craft.craft", template.background).setPosAndSize(this.field_230708_k_ / 2 - 40, template.playerSlots.yPos() - 17, 80, 14)).setEnabledCallback(() -> this.tile.getActiveRecipe() != null && !this.tile.isCrafting())).onButtonReleased(b -> this.tile.sendPacketToServer(output -> {}, 0));
        this.stackIcon = new GuiStackIcon(null);
        template.background.addChild((GuiElement)this.stackIcon);
        this.toolkit.center((GuiElement)this.stackIcon, craftArea, 0, 3);
        template.background.addChild(new IngredRenderer(this.tile).setPosAndSize(craftArea));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.currentRecipe = this.tile.func_145831_w().func_199532_z().func_215371_a(DraconicAPI.FUSION_RECIPE_TYPE, (IInventory)this.tile, this.tile.func_145831_w()).orElse(null);
        if (this.currentRecipe == null) {
            this.stackIcon.setStack(ItemStack.field_190927_a);
        } else {
            this.stackIcon.setStack(this.currentRecipe.func_77571_b());
        }
    }

    private static class IngredRenderer
    extends GuiElement<IngredRenderer> {
        private TileFusionCraftingCore core;
        private List<ItemStack> lastStacks = new ArrayList<ItemStack>();

        public IngredRenderer(TileFusionCraftingCore core) {
            this.core = core;
        }

        private void setInjectors() {
            int i;
            int centerX = this.xPos() + this.xSize() / 2;
            ArrayList columns = new ArrayList();
            int colCount = Math.min((int)Math.ceil((double)this.lastStacks.size() / 12.0), 3) * 2;
            for (i = 0; i < colCount; ++i) {
                columns.add(new ArrayList());
            }
            for (i = 0; i < this.lastStacks.size(); ++i) {
                ((ArrayList)columns.get(i % colCount)).add(this.lastStacks.get(i));
            }
            int innerOffset = colCount == 6 ? 44 : (colCount == 4 ? 53 : 65);
            for (int column = 0; column < columns.size(); ++column) {
                List stacks = (List)columns.get(column);
                int offset = column / 2 * 20;
                int xPos = column % 2 == 0 ? centerX + innerOffset + offset : centerX - innerOffset - offset - 18;
                int yHeight = Math.min(stacks.size() * 20, this.ySize());
                for (int i2 = 0; i2 < stacks.size(); ++i2) {
                    int yPos = this.yPos() + this.ySize() / 2 - yHeight / 2 + i2 * (yHeight / stacks.size());
                    this.addChild(new GuiStackIcon().setStack((ItemStack)stacks.get(i2)).setPos(xPos, yPos));
                }
            }
        }

        public boolean onUpdate() {
            List stacks = this.core.getInjectors().stream().map(IFusionInjector::getInjectorStack).filter(injectorStack -> !injectorStack.func_190926_b()).collect(Collectors.toList());
            if (!stacks.equals(this.lastStacks)) {
                this.childElements.clear();
                this.lastStacks = stacks;
                if (!this.lastStacks.isEmpty()) {
                    this.setInjectors();
                }
                return true;
            }
            return super.onUpdate();
        }
    }
}

