/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.GuiButtonAHeight;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiEnergyCore
extends ModularGuiContainer<ContainerBCTile<TileEnergyCore>> {
    public PlayerEntity player;
    public TileEnergyCore tile;
    private Button activate;
    private Button tierUp;
    private Button tierDown;
    private Button toggleGuide;
    private Button assembleCore;
    private Button layerPlus;
    private Button layerMinus;
    public static int layer = -1;
    private long ticks;
    private long seconds;
    private long minutes;
    private long hours;
    private long days;
    private long years;

    public GuiEnergyCore(ContainerBCTile<TileEnergyCore> container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.tile = (TileEnergyCore)container.tile;
        this.field_146999_f = 180;
        this.field_147000_g = 200;
        this.player = playerInventory.field_70458_d;
        this.dumbGui = true;
    }

    public void addElements(GuiElementManager manager) {
        ((ContainerBCTile)this.container).field_75151_b.forEach(slot -> {
            if (slot.field_75222_d < 9) {
                slot.field_75223_e += 10;
                slot.field_75221_f += 174;
            } else {
                slot.field_75223_e += 10;
                slot.field_75221_f += 98;
            }
        });
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        super.func_231158_b_(mc, width, height);
        this.activate = new GuiButtonAHeight(this.field_147003_i + 9, this.field_147009_r + 99, 162, 12, "Activate-L", b -> this.tile.sendPacketToServer(output -> {}, 0));
        this.func_230480_a_((Widget)this.activate);
        this.tierUp = new GuiButtonAHeight(this.field_147003_i + 91, this.field_147009_r + 86, 80, 12, I18n.func_135052_a((String)"button.de.tierUp.txt", (Object[])new Object[0]), b -> this.tile.sendPacketToServer(output -> {}, 1));
        this.func_230480_a_((Widget)this.tierUp);
        this.tierDown = new GuiButtonAHeight(this.field_147003_i + 9, this.field_147009_r + 86, 80, 12, I18n.func_135052_a((String)"button.de.tierDown.txt", (Object[])new Object[0]), b -> this.tile.sendPacketToServer(output -> {}, 2));
        this.func_230480_a_((Widget)this.tierDown);
        this.toggleGuide = new GuiButtonAHeight(this.field_147003_i + 9, this.field_147009_r + 73, 162, 12, I18n.func_135052_a((String)"button.de.buildGuide.txt", (Object[])new Object[0]), b -> this.tile.sendPacketToServer(output -> {}, 3));
        this.func_230480_a_((Widget)this.toggleGuide);
        this.assembleCore = new GuiButtonAHeight(this.field_147003_i + 9, this.field_147009_r + 99, 162, 12, I18n.func_135052_a((String)"button.de.assembleCore.txt", (Object[])new Object[0]), b -> this.tile.sendPacketToServer(output -> {}, 4));
        this.func_230480_a_((Widget)this.assembleCore);
        this.layerMinus = new GuiButtonAHeight(this.field_147003_i + 5, this.field_147009_r - 13, 70, 12, "Layer-", b -> this.layer(-1));
        this.func_230480_a_((Widget)this.layerMinus);
        this.layerPlus = new GuiButtonAHeight(this.field_147003_i + 105, this.field_147009_r - 13, 70, 12, "Layer+", b -> this.layer(1));
        this.func_230480_a_((Widget)this.layerPlus);
        this.layerPlus.field_230694_p_ = this.tile.buildGuide.get();
        this.layerMinus.field_230694_p_ = this.tile.buildGuide.get();
        this.updateButtonStates();
    }

    protected void func_230450_a_(MatrixStack mStack, float partialTicks, int mouseX, int mouseY) {
        GuiHelperOld.drawGuiBaseBackground((AbstractGui)this, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.field_146999_f, (int)this.field_147000_g);
        GuiHelperOld.drawPlayerSlots((AbstractGui)this, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 115), (boolean)true);
        GuiEnergyCore.func_238471_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.de.energyStorageCore.name", (Object[])new Object[]{this.tile.tier.get()}), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 5), (int)65535);
        if (this.tile.active.get()) {
            GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.de.capacity.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 16), (int)0xFFAA00, (boolean)true);
            String capText = this.tile.tier.get() == 8 ? I18n.func_135052_a((String)"gui.de.almostInfinite.txt", (Object[])new Object[0]) : Utils.formatNumber((long)this.tile.getExtendedCapacity());
            GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)capText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 27), (int)0x555555, (boolean)false);
            DecimalFormat energyValue = new DecimalFormat("###.###");
            double percent = (double)this.tile.getExtendedStorage() / (double)this.tile.getExtendedCapacity() * 100.0;
            GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"info.bc.charge.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 38), (int)0xFFAA00, (boolean)true);
            GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)(Utils.formatNumber((long)this.tile.getExtendedStorage()) + " OP [" + energyValue.format(percent) + "%]"), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 49), (int)0x555555, (boolean)false);
            int coreColour = this.tile.transferRate.get() > 0L ? 65280 : (this.tile.transferRate.get() < 0L ? 0xFF0000 : 0x222222);
            String transfer = (this.tile.transferRate.get() > 0L ? "+" : (this.tile.transferRate.get() < 0L ? "-" : "")) + Utils.formatNumber((long)Math.abs(this.tile.transferRate.get())) + " OP/t";
            GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.de.transfer.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 59), (int)0xFFAA00, (boolean)true);
            GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)transfer, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 70), (int)coreColour, (this.tile.transferRate.get() > 0L ? 1 : 0) != 0);
            if (this.tile.transferRate.get() != 0L) {
                String time = "";
                if (this.years > 0L) {
                    time = time + GuiEnergyCore.formatYear(this.years) + ", ";
                    time = time + this.days % 365L + " Days";
                } else if (this.days > 0L) {
                    time = time + this.days % 365L + " Days, ";
                    time = time + (this.hours % 24L < 10L ? "0" : "") + this.hours % 24L + ":";
                    time = time + (this.minutes % 60L < 10L ? "0" : "") + this.minutes % 60L + ":";
                    time = time + (this.seconds % 60L < 10L ? "0" : "") + this.seconds % 60L + "." + (this.ticks % 20L < 10L ? "0" : "") + this.ticks % 20L;
                } else {
                    time = time + (this.hours % 24L < 10L ? "0" : "") + this.hours % 24L + ":";
                    time = time + (this.minutes % 60L < 10L ? "0" : "") + this.minutes % 60L + ":";
                    time = time + (this.seconds % 60L < 10L ? "0" : "") + this.seconds % 60L + "." + (this.ticks % 20L < 10L ? "0" : "") + this.ticks % 20L;
                }
                GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)time, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 70 + 10), (int)0x555555, (boolean)false);
            }
        } else {
            int stabColour = this.tile.stabilizersOK.get() ? 65280 : 0xFF0000;
            String stabText = I18n.func_135052_a((String)"gui.de.stabilizers.txt", (Object[])new Object[0]) + ": " + (this.tile.stabilizersOK.get() ? I18n.func_135052_a((String)"gui.de.valid.txt", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.invalid.txt", (Object[])new Object[0]));
            GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)stabText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 18), (int)stabColour, (boolean)this.tile.stabilizersOK.get());
            if (this.tile.tier.get() >= 5) {
                GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.de.advancedStabilizersRequired.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 28), (int)0x777777, (boolean)false);
            }
            int coreColour = this.tile.coreValid.get() ? 65280 : 0xFF0000;
            String coreText = I18n.func_135052_a((String)"gui.de.core.txt", (Object[])new Object[0]) + ": " + (this.tile.coreValid.get() ? I18n.func_135052_a((String)"gui.de.valid.txt", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.invalid.txt", (Object[])new Object[0]));
            GuiHelperOld.drawCenteredString((FontRenderer)this.field_230712_o_, (String)coreText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 36), (int)coreColour, (boolean)this.tile.coreValid.get());
            if (!this.tile.coreValid.get()) {
                // empty if block
            }
        }
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        if (this.tile.active.get()) {
            if (GuiHelperOld.isInRect((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 27), (int)(this.field_146999_f - 80), (int)8, (double)mouseX, (double)mouseY)) {
                this.func_238652_a_(mStack, (ITextComponent)new StringTextComponent(TextFormatting.GRAY + "[" + Utils.addCommas((long)this.tile.getExtendedCapacity()) + " OP]"), mouseX, mouseY);
            }
            if (GuiHelperOld.isInRect((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 48), (int)(this.field_146999_f - 80), (int)8, (double)mouseX, (double)mouseY)) {
                this.func_238652_a_(mStack, (ITextComponent)new StringTextComponent(TextFormatting.GRAY + "[" + Utils.addCommas((long)this.tile.getExtendedStorage()) + " OP]"), mouseX, mouseY);
            }
        }
        if (this.tile.buildGuide.get()) {
            GuiEnergyCore.func_238471_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (String)(layer == -1 ? "All" : layer + ""), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r - 10), (int)0xFFFFFF);
        }
        this.func_230459_a_(mStack, mouseX, mouseY);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateButtonStates();
        if (this.tile.transferRate.get() != 0L) {
            long space = this.tile.transferRate.get() > 0L ? this.tile.getExtendedCapacity() - this.tile.getExtendedStorage() : this.tile.getExtendedStorage();
            this.ticks = Math.abs(space / this.tile.transferRate.get());
        } else {
            this.ticks = 0L;
        }
        this.seconds = this.ticks / 20L;
        this.minutes = this.seconds / 60L;
        this.hours = this.minutes / 60L;
        this.days = this.hours / 24L;
        this.years = this.days / 365L;
    }

    private void updateButtonStates() {
        if (this.tile.active.get()) {
            this.activate.func_238482_a_((ITextComponent)new TranslationTextComponent("button.de.deactivate.txt"));
        } else {
            this.activate.func_238482_a_((ITextComponent)new TranslationTextComponent("button.de.activate.txt"));
            this.toggleGuide.func_238482_a_((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"button.de.buildGuide.txt", (Object[])new Object[0]) + " " + (this.tile.buildGuide.get() ? I18n.func_135052_a((String)"gui.de.active.txt", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.inactive.txt", (Object[])new Object[0]))));
            this.tierUp.field_230693_o_ = this.tile.tier.get() < 8;
            this.tierDown.field_230693_o_ = this.tile.tier.get() > 1;
        }
        this.toggleGuide.field_230694_p_ = !this.tile.active.get();
        this.tierDown.field_230694_p_ = this.toggleGuide.field_230694_p_;
        this.tierUp.field_230694_p_ = this.toggleGuide.field_230694_p_;
        this.assembleCore.field_230694_p_ = !this.tile.coreValid.get();
        this.activate.field_230694_p_ = this.tile.coreValid.get();
        this.layerPlus.field_230694_p_ = this.tile.buildGuide.get();
        this.layerMinus.field_230694_p_ = this.tile.buildGuide.get();
    }

    public static String formatYear(long value) {
        if (value < 1000L) {
            return value + " Years";
        }
        if (value < 1000000L) {
            return (double)Math.round((double)value / 10.0) / 100.0 + " Thousand Years";
        }
        if (value < 1000000000L) {
            return (double)Math.round((double)value / 10000.0) / 100.0 + " Million Years";
        }
        if (value < 1000000000000L) {
            return (double)Math.round((double)value / 1.0E7) / 100.0 + " Billion Years";
        }
        if (value < 1000000000000000L) {
            return (double)Math.round((double)value / 1.0E10) / 100.0 + " Trillion Years";
        }
        if (value < 1000000000000000000L) {
            return (double)Math.round((double)value / 1.0E13) / 100.0 + " Quadrillion Years";
        }
        if (value <= Long.MAX_VALUE) {
            return (double)Math.round((double)value / 1.0E16) / 100.0 + " Quintillion Years";
        }
        return "Something is very broken!!!!";
    }

    protected void layer(int add) {
        layer = MathHelper.clip((int)(layer + add), (int)-1, (int)6);
    }
}

