/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.FeatureUtils;
import com.brandon3055.draconicevolution.blocks.PlacedItem;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TilePlacedItem
extends TileBCore {
    public final ManagedByte displayCount = (ManagedByte)this.register((IManagedData)new ManagedByte("display_count", 1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool toolDisplay = (ManagedBool)this.register((IManagedData)new ManagedBool("tool_display", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool altRenderMode = (ManagedBool)this.register((IManagedData)new ManagedBool("alt_render_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedByte[] rotation = new ManagedByte[4];
    public Direction facing = Direction.NORTH;
    private boolean[] isBlock = new boolean[]{false, false, false, false};
    public PlacedItemInventory inventory = new PlacedItemInventory(this);
    private IndexedCuboid6 blockBounds = new IndexedCuboid6((Object)0, new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    private List<IndexedCuboid6> indexedCuboids = new LinkedList<IndexedCuboid6>();
    private static final Transformation[] rotations = new Transformation[]{Rotation.sideRotations[3], Rotation.sideRotations[2], Rotation.sideRotations[0], Rotation.sideRotations[1], Rotation.quarterRotations[3], Rotation.quarterRotations[1]};

    public TilePlacedItem() {
        super(DEContent.tile_placed_item);
        for (int i = 0; i < this.rotation.length; ++i) {
            this.rotation[i] = (ManagedByte)this.register((IManagedData)new ManagedByte("rotation" + i, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
        }
    }

    public void handleClick(int hit, PlayerEntity player) {
        if (!player.func_184614_ca().func_190926_b() && ModHelper.isWrench(player.func_184614_ca())) {
            this.altRenderMode.invert();
            LogHelper.dev(this.altRenderMode);
            super.tick();
            return;
        }
        if (player.func_225608_bj_()) {
            if (hit == -1) {
                return;
            }
            int index = hit - 1;
            if (index >= 0 && index < this.rotation.length) {
                this.rotation[index].inc();
                BCoreNetwork.sendSound((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187632_cP, (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (float)(0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), (boolean)false);
                super.tick();
            }
            return;
        }
        if (hit == 0) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                FeatureUtils.dropItemNoDellay((ItemStack)this.inventory.func_70301_a(i), (World)this.field_145850_b, (Vector3)Vector3.fromEntity((Entity)player));
            }
            this.inventory.stacks.clear();
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        } else if (!this.inventory.func_70301_a(hit - 1).func_190926_b()) {
            FeatureUtils.dropItemNoDellay((ItemStack)this.inventory.func_70301_a(hit - 1), (World)this.field_145850_b, (Vector3)Vector3.fromEntity((Entity)player));
            this.inventory.func_70299_a(hit - 1, ItemStack.field_190927_a);
        }
    }

    public void breakBlock() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            FeatureUtils.dropItemNoDellay((ItemStack)this.inventory.func_70301_a(i), (World)this.field_145850_b, (Vector3)Vector3.fromTileCenter((TileEntity)this));
        }
        this.inventory.stacks.clear();
    }

    private synchronized void calculateBounds() {
        BlockState state = this.func_195044_w();
        Cuboid6 box = new Cuboid6(0.5, 0.0, 0.5, 0.5, 0.0, 0.5).apply(Rotation.sideRotations[((Direction)state.func_177229_b((Property)PlacedItem.FACING)).func_176745_a()].at(Vector3.CENTER));
        int i = 0;
        for (Cuboid6 cuboid6 : this.indexedCuboids) {
            ++i;
            box.enclose(cuboid6);
        }
        if (this.facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            box.setSide(this.facing.func_176745_a() ^ 1, 0.01);
        } else {
            box.setSide(this.facing.func_176745_a() ^ 1, 0.99);
        }
        if (i > 1) {
            Direction.Axis axis = this.facing.func_176740_k();
            box.expand(new Vector3(axis == Direction.Axis.X ? -0.02 : 0.03, axis == Direction.Axis.Y ? -0.02 : 0.03, axis == Direction.Axis.Z ? -0.02 : 0.03));
        }
        this.blockBounds = new IndexedCuboid6((Object)0, box);
    }

    private synchronized void recalculateCuboids() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() != DEContent.placed_item) {
            return;
        }
        this.indexedCuboids = new ArrayList<IndexedCuboid6>();
        double scale = this.displayCount.get() == 1 && (this.toolDisplay.get() || this.altRenderMode.get()) ? 0.2 : 0.32;
        Transformation rotation = rotations[((Direction)state.func_177229_b((Property)PlacedItem.FACING)).func_176745_a()].at(Vector3.CENTER);
        double offset = 0.225;
        double blockH = 0.36;
        double itemH = 0.03;
        if (this.displayCount.get() == 1) {
            this.indexedCuboids.add(new IndexedCuboid6((Object)1, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[0] ? blockH : itemH).apply(rotation)));
        } else if (this.displayCount.get() == 2) {
            this.indexedCuboids.add(new IndexedCuboid6((Object)1, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[0] ? blockH : itemH).apply((Transformation)new Translation(-offset, 0.0, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)2, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[1] ? blockH : itemH).apply((Transformation)new Translation(offset, 0.0, 0.0).with(rotation))));
        } else if (this.displayCount.get() == 3) {
            this.indexedCuboids.add(new IndexedCuboid6((Object)1, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[0] ? blockH : itemH).apply((Transformation)new Translation(0.0, offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)2, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[1] ? blockH : itemH).apply((Transformation)new Translation(-offset, -offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)3, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[2] ? blockH : itemH).apply((Transformation)new Translation(offset, -offset, 0.0).with(rotation))));
        } else if (this.displayCount.get() == 4) {
            this.indexedCuboids.add(new IndexedCuboid6((Object)1, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[0] ? blockH : itemH).apply((Transformation)new Translation(-offset, offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)2, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[1] ? blockH : itemH).apply((Transformation)new Translation(offset, offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)3, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[2] ? blockH : itemH).apply((Transformation)new Translation(-offset, -offset, 0.0).with(rotation))));
            this.indexedCuboids.add(new IndexedCuboid6((Object)4, new Cuboid6(scale, scale, 0.0, 1.0 - scale, 1.0 - scale, this.isBlock[3] ? blockH : itemH).apply((Transformation)new Translation(offset, -offset, 0.0).with(rotation))));
        }
        this.indexedCuboids = ImmutableList.copyOf(this.indexedCuboids);
    }

    public synchronized List<IndexedCuboid6> getCachedRenderCuboids() {
        if (this.indexedCuboids.isEmpty()) {
            this.recalculateCuboids();
        }
        return this.indexedCuboids;
    }

    public void updateBlock() {
        super.updateBlock();
        this.recalculateCuboids();
    }

    public void writeExtraNBT(CompoundNBT compound) {
        super.writeExtraNBT(compound);
        compound.func_74774_a("Facing", (byte)this.facing.func_176745_a());
        for (int i = 0; i < this.isBlock.length; ++i) {
            compound.func_74757_a("IsBlock" + i, this.isBlock[i]);
        }
        this.inventory.toNBT(compound);
    }

    public void readExtraNBT(CompoundNBT compound) {
        super.readExtraNBT(compound);
        this.facing = Direction.func_82600_a((int)compound.func_74771_c("Facing"));
        for (int i = 0; i < this.isBlock.length; ++i) {
            this.isBlock[i] = compound.func_74767_n("IsBlock" + i);
        }
        this.inventory.fromNBT(compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, -1, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public static class PlacedItemInventory
    implements IInventory {
        private LinkedList<ItemStack> stacks = new LinkedList();
        private TilePlacedItem tile;

        public PlacedItemInventory(TilePlacedItem tile) {
            this.tile = tile;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.setSlot(index, stack);
            int count = 0;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                ((TilePlacedItem)this.tile).isBlock[i] = this.func_70301_a(i).func_77973_b() instanceof BlockItem;
                ++count;
            }
            if (count == 0) {
                this.tile.field_145850_b.func_217377_a(this.tile.func_174877_v(), false);
            } else {
                this.tile.displayCount.set((int)((byte)count));
                ItemStack stack0 = this.func_70301_a(0);
                this.tile.toolDisplay.set(count == 1 && stack0.func_77973_b().func_77616_k(stack0));
                this.tile.tick();
                this.tile.updateBlock();
            }
        }

        public int func_70302_i_() {
            return 4;
        }

        public ItemStack func_70301_a(int index) {
            return index >= 0 && index < this.stacks.size() && this.stacks.get(index) != null ? this.stacks.get(index) : ItemStack.field_190927_a;
        }

        private void setSlot(int index, ItemStack stack) {
            if (index < 0 || index >= 4) {
                return;
            }
            if (stack.func_190926_b()) {
                if (index < this.stacks.size()) {
                    this.stacks.remove(index);
                }
            } else if (index < this.stacks.size()) {
                this.stacks.set(index, stack);
            } else {
                this.stacks.add(stack);
            }
            this.func_70296_d();
        }

        protected void toNBT(CompoundNBT compound) {
            ListNBT itemList = new ListNBT();
            for (ItemStack stack : this.stacks) {
                if (stack.func_190926_b()) continue;
                itemList.add((Object)stack.func_77955_b(new CompoundNBT()));
            }
            compound.func_218657_a("InventoryStacks", (INBT)itemList);
        }

        protected void fromNBT(CompoundNBT compound) {
            this.stacks.clear();
            ListNBT itemList = compound.func_150295_c("InventoryStacks", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                this.stacks.add(ItemStack.func_199557_a((CompoundNBT)itemList.func_150305_b(i)));
            }
        }

        public ItemStack func_70304_b(int index) {
            ItemStack stack = this.func_70301_a(index);
            this.func_70299_a(index, ItemStack.field_190927_a);
            return stack;
        }

        public boolean func_191420_l() {
            return this.stacks.isEmpty();
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = index >= 0 && index < this.stacks.size() && !this.stacks.get(index).func_190926_b() && count > 0 ? this.stacks.get(index).func_77979_a(count) : ItemStack.field_190927_a;
            if (!stack.func_190926_b()) {
                this.func_70296_d();
            }
            return stack;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public void func_174888_l() {
            this.stacks.clear();
            this.tile.field_145850_b.func_217377_a(this.tile.func_174877_v(), false);
        }
    }
}

