/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedDouble;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.HolidayHelper;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.reactor.ProcessExplosion;
import com.brandon3055.draconicevolution.blocks.reactor.ReactorEffectHandler;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import com.brandon3055.draconicevolution.client.gui.GuiReactor;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerReactor;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileReactorCore
extends TileBCore
implements ITickableTileEntity,
INamedContainerProvider {
    public int frameMoveContactPoints = 0;
    public boolean isFrameMoving = false;
    public boolean moveBlocksProvided = false;
    public static final int COMPONENT_MAX_DISTANCE = 8;
    public final ManagedVec3I[] componentPositions = new ManagedVec3I[6];
    private final ManagedEnum<Direction.Axis> stabilizerAxis = (ManagedEnum)this.register((IManagedData)new ManagedEnum("stabilizer_axis", (Enum)Direction.Axis.Y, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool structureValid = (ManagedBool)this.register((IManagedData)new ManagedBool("structure_valid", false, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedString structureError = (ManagedString)this.register((IManagedData)new ManagedString("structure_error", "", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private int tick = 0;
    private Map<BlockPos, Integer> blockIntrusions = new HashMap<BlockPos, Integer>();
    public final ManagedEnum<ReactorState> reactorState = (ManagedEnum)this.register((IManagedData)new ManagedEnum("reactor_state", (Enum)ReactorState.INVALID, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedDouble reactableFuel = (ManagedDouble)this.register((IManagedData)new ManagedDouble("reactable_fuel", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedDouble convertedFuel = (ManagedDouble)this.register((IManagedData)new ManagedDouble("converted_fuel", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedDouble temperature = (ManagedDouble)this.register((IManagedData)new ManagedDouble("temperature", 20.0, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public static final double MAX_TEMPERATURE = 10000.0;
    public final ManagedDouble shieldCharge = (ManagedDouble)this.register((IManagedData)new ManagedDouble("shield_charge", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedDouble maxShieldCharge = (ManagedDouble)this.register((IManagedData)new ManagedDouble("max_shield_charge", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedLong saturation = (ManagedLong)this.register((IManagedData)new ManagedLong("saturation", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedLong maxSaturation = (ManagedLong)this.register((IManagedData)new ManagedLong("max_saturation", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedDouble tempDrainFactor = (ManagedDouble)this.register((IManagedData)new ManagedDouble("temp_drain_factor", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedDouble generationRate = (ManagedDouble)this.register((IManagedData)new ManagedDouble("generation_rate", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedInt fieldDrain = (ManagedInt)this.register((IManagedData)new ManagedInt("field_drain", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedDouble fieldInputRate = (ManagedDouble)this.register((IManagedData)new ManagedDouble("field_input_rate", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedDouble fuelUseRate = (ManagedDouble)this.register((IManagedData)new ManagedDouble("fuel_use_rate", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedBool startupInitialized = (ManagedBool)this.register((IManagedData)new ManagedBool("startup_initialized", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedBool failSafeMode = (ManagedBool)this.register((IManagedData)new ManagedBool("fail_safe_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private ProcessExplosion explosionProcess = null;
    public final ManagedInt explosionCountdown = (ManagedInt)this.register((IManagedData)new ManagedInt("explosion_countdown", -1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    private int minExplosionDelay = 0;
    public float coreAnimation = 0.0f;
    public float shieldAnimation = 0.0f;
    public float shieldAnimationState = 0.0f;
    public final ManagedDouble shaderAnimationState = (ManagedDouble)this.register((IManagedData)new ManagedDouble("shader_animation_state", 0.0, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedDouble animExtractState = (ManagedDouble)this.register((IManagedData)new ManagedDouble("anim_extract_state", 0.0, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ReactorEffectHandler effectHandler;
    public static final byte ID_CHARGE = 0;
    public static final byte ID_ACTIVATE = 1;
    public static final byte ID_SHUTDOWN = 2;
    public static final byte ID_FAIL_SAFE = 3;
    public boolean inView = false;
    public int viewTicks = 0;
    public Roller roller = null;

    public TileReactorCore() {
        super(DEContent.tile_reactor_core);
        for (int i = 0; i < this.componentPositions.length; ++i) {
            this.componentPositions[i] = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("component_position" + i, new Vec3I(0, 0, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        }
        this.effectHandler = DraconicEvolution.proxy.createReactorFXHandler(this);
    }

    public int getAccessDistanceSq() {
        return 256;
    }

    public void func_73660_a() {
        if (this.field_174879_c.func_177958_n() > 1000) {
            LogHelper.dev(this.field_174879_c);
        }
        super.tick();
        this.updateCoreLogic();
        this.frameMoveContactPoints = 0;
        this.isFrameMoving = false;
        this.moveBlocksProvided = false;
        if (this.field_145850_b.field_72995_K && this.effectHandler != null) {
            this.effectHandler.updateEffects();
            if (HolidayHelper.isAprilFools()) {
                if (this.inView) {
                    ++this.viewTicks;
                    if (this.viewTicks > 100 && this.roller == null) {
                        if (this.field_145850_b.field_73012_v.nextInt(25) == 0) {
                            this.roller = new Roller(Vec3D.getCenter((TileEntity)this), this.field_145850_b, this.getCoreDiameter());
                        } else {
                            this.viewTicks = 0;
                        }
                    }
                } else {
                    if (this.viewTicks > 0 && this.roller != null && this.roller.age > 100) {
                        this.roller = null;
                    }
                    this.viewTicks = 0;
                }
                if (this.roller != null) {
                    this.roller.update();
                }
            }
        }
        ++this.tick;
    }

    private void updateCoreLogic() {
        if (this.field_145850_b.field_72995_K) {
            this.checkPlayerCollision();
            this.coreAnimation = (float)((double)this.coreAnimation + this.shaderAnimationState.get());
            if (this.maxShieldCharge.get() == 0.0) {
                this.shaderAnimationState.set(0.0);
                this.shieldAnimation = 0.0f;
            } else {
                this.shieldAnimationState = MathHelper.clip((float)((float)(this.shieldCharge.get() / this.maxShieldCharge.get()) * 10.0f), (float)0.0f, (float)1.0f);
                this.shieldAnimation += this.shieldAnimationState;
            }
            if (this.reactorState.get() == ReactorState.BEYOND_HOPE) {
                this.shieldAnimationState = this.field_145850_b.field_73012_v.nextInt(10) == 0 ? 0.0f : 1.0f;
                this.shieldAnimation += this.shieldAnimationState;
            }
            return;
        }
        this.shaderAnimationState.set(Math.min(1.0, (this.temperature.get() - 20.0) / 1000.0));
        this.animExtractState.set(0.0);
        switch ((ReactorState)this.reactorState.get()) {
            case INVALID: {
                this.updateOfflineState();
                break;
            }
            case COLD: {
                this.updateOfflineState();
                break;
            }
            case WARMING_UP: {
                this.initializeStartup();
                this.checkBlockIntrusions();
                break;
            }
            case RUNNING: {
                this.updateOnlineState();
                this.checkBlockIntrusions();
                if (this.failSafeMode.get() && this.temperature.get() < 2500.0 && (double)this.saturation.get() / (double)this.maxSaturation.get() >= 0.99) {
                    LogHelper.dev("Reactor: Initiating Fail-Safe Shutdown!");
                    this.shutdownReactor();
                }
                double sat = 1.0 - (double)this.saturation.get() / (double)this.maxSaturation.get();
                this.animExtractState.set(Math.min(1.0, sat * 10.0));
                break;
            }
            case STOPPING: {
                this.updateOnlineState();
                this.checkBlockIntrusions();
                if (!(this.temperature.get() <= 2000.0)) break;
                this.reactorState.set((Enum)ReactorState.COOLING);
                break;
            }
            case COOLING: {
                this.updateOfflineState();
                if (!(this.temperature.get() <= 100.0)) break;
                this.reactorState.set((Enum)ReactorState.COLD);
                break;
            }
            case BEYOND_HOPE: {
                this.checkBlockIntrusions();
                this.updateCriticalState();
            }
        }
    }

    private void updateOfflineState() {
        if (this.temperature.get() > 20.0) {
            this.temperature.subtract(0.5);
        }
        if (this.shieldCharge.get() > 0.0) {
            this.shieldCharge.subtract(this.maxShieldCharge.get() * 5.0E-4 * this.field_145850_b.field_73012_v.nextDouble());
        } else if (this.shieldCharge.get() < 0.0) {
            this.shieldCharge.zero();
        }
        if (this.saturation.get() > 0L) {
            this.saturation.subtract((long)((int)((double)this.maxSaturation.get() * 2.0E-6 * this.field_145850_b.field_73012_v.nextDouble())));
        } else if (this.saturation.get() < 0L) {
            this.saturation.zero();
        }
    }

    private void initializeStartup() {
        if (!this.startupInitialized.get()) {
            double totalFuel = this.reactableFuel.get() + this.convertedFuel.get();
            this.maxShieldCharge.set(totalFuel * 96.45061728395062 * 100.0);
            this.maxSaturation.set((long)((int)(totalFuel * 96.45061728395062 * 1000.0)));
            if (this.saturation.get() > this.maxSaturation.get()) {
                this.saturation.set(this.maxSaturation.get());
            }
            if (this.shieldCharge.get() > this.maxShieldCharge.get()) {
                this.shieldCharge.set(this.maxShieldCharge.get());
            }
            this.startupInitialized.set(true);
        }
    }

    private void updateOnlineState() {
        double coreSat = (double)this.saturation.get() / (double)this.maxSaturation.get();
        double negCSat = (1.0 - coreSat) * 99.0;
        double temp50 = Math.min(this.temperature.get() / 10000.0 * 50.0, 99.0);
        double tFuel = this.convertedFuel.get() + this.reactableFuel.get();
        double convLVL = this.convertedFuel.get() / tFuel * 1.3 - 0.3;
        double tempOffset = 444.7;
        double tempRiseExpo = negCSat * negCSat * negCSat / (100.0 - negCSat) + tempOffset;
        double tempRiseResist = temp50 * temp50 * temp50 * temp50 / (100.0 - temp50);
        double riseAmount = (tempRiseExpo - tempRiseResist * (1.0 - convLVL) + convLVL * 1000.0) / 10000.0;
        if (this.reactorState.get() == ReactorState.STOPPING && convLVL < 1.0) {
            if (this.temperature.get() <= 2001.0) {
                this.reactorState.set((Enum)ReactorState.COOLING);
                this.startupInitialized.set(false);
                return;
            }
            if ((double)this.saturation.get() >= (double)this.maxSaturation.get() * 0.99 && this.reactableFuel.get() > 0.0) {
                this.temperature.subtract(1.0 - convLVL);
            } else {
                this.temperature.add(riseAmount * 10.0);
            }
        } else {
            this.temperature.add(riseAmount * 10.0);
        }
        int baseMaxRFt = (int)((double)this.maxSaturation.get() / 1000.0 * DEConfig.reactorOutputMultiplier * 1.5 * 10.0);
        int maxRFt = (int)((double)baseMaxRFt * (1.0 + convLVL * 2.0));
        this.generationRate.set((1.0 - coreSat) * (double)maxRFt);
        this.saturation.add((long)((int)this.generationRate.get()));
        this.tempDrainFactor.set(this.temperature.get() > 8000.0 ? 1.0 + (this.temperature.get() - 8000.0) * (this.temperature.get() - 8000.0) * 2.5E-6 : (this.temperature.get() > 2000.0 ? 1.0 : (this.temperature.get() > 1000.0 ? (this.temperature.get() - 1000.0) / 1000.0 : 0.0)));
        this.fieldDrain.set((int)Math.min(this.tempDrainFactor.get() * Math.max(0.01, 1.0 - coreSat) * ((double)baseMaxRFt / 10.923556), 2.147483647E9));
        double fieldNegPercent = 1.0 - this.shieldCharge.get() / this.maxShieldCharge.get();
        this.fieldInputRate.set((double)this.fieldDrain.get() / fieldNegPercent);
        this.shieldCharge.subtract(Math.min((double)this.fieldDrain.get(), this.shieldCharge.get()));
        this.fuelUseRate.set(this.tempDrainFactor.get() * (1.0 - coreSat) * (0.001 * DEConfig.reactorFuelUsageMultiplier * 5.0));
        if (this.reactableFuel.get() > 0.0) {
            this.convertedFuel.add(this.fuelUseRate.get());
            this.reactableFuel.subtract(this.fuelUseRate.get());
        }
        if (this.shieldCharge.get() <= 0.0 && this.temperature.get() > 2000.0 && this.reactorState.get() != ReactorState.BEYOND_HOPE) {
            this.reactorState.set((Enum)ReactorState.BEYOND_HOPE);
            for (int i = 0; i < this.componentPositions.length; ++i) {
                ManagedVec3I v = this.componentPositions[i];
                if (v.get().sum() <= 0) continue;
                BlockPos p = this.getOffsetPos(v.get()).func_177972_a(Direction.func_82600_a((int)i).func_176734_d());
                this.field_145850_b.func_217398_a(null, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, 4.0f, true, Explosion.Mode.DESTROY);
            }
        }
        if (this.tick % 20 == 0) {
            this.func_70296_d();
        }
    }

    public void updateCriticalState() {
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        this.shieldCharge.set((double)this.field_145850_b.field_73012_v.nextInt(Math.max(1, (int)(this.maxShieldCharge.get() * 0.01))));
        this.animExtractState.set(1.0);
        this.temperature.set(MathHelper.approachExp((double)this.temperature.get(), (double)12000.0, (double)5.0E-4));
        if (DEConfig.disableLargeReactorBoom) {
            if (this.explosionCountdown.get() == -1) {
                this.explosionCountdown.set(1200 + this.field_145850_b.field_73012_v.nextInt(2400));
            }
            if (this.explosionCountdown.dec() <= 0) {
                this.minimalBoom();
            }
            return;
        }
        if (this.explosionProcess == null) {
            double radius = MathUtils.map((double)(this.convertedFuel.get() + this.reactableFuel.get()), (double)144.0, (double)10368.0, (double)50.0, (double)350.0) * DEConfig.reactorExplosionScale;
            this.explosionProcess = new ProcessExplosion(this.field_174879_c, (int)radius, (ServerWorld)this.field_145850_b, -1);
            ProcessHandler.addProcess((IProcess)this.explosionProcess);
            this.explosionCountdown.set(-1);
            this.minExplosionDelay = 1200 + this.field_145850_b.field_73012_v.nextInt(2400);
            return;
        }
        --this.minExplosionDelay;
        if (!this.explosionProcess.isCalculationComplete()) {
            return;
        }
        LogHelper.dev(this.explosionCountdown.get() / 20);
        if (this.explosionCountdown.get() == -1) {
            this.explosionCountdown.set(1200 + Math.max(0, this.minExplosionDelay));
        }
        if (this.explosionCountdown.dec() <= 0) {
            this.explosionProcess.detonate();
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public boolean canCharge() {
        if (!this.field_145850_b.field_72995_K && !this.validateStructure()) {
            return false;
        }
        if (this.reactorState.get() == ReactorState.BEYOND_HOPE) {
            return false;
        }
        return (this.reactorState.get() == ReactorState.COLD || this.reactorState.get() == ReactorState.COOLING) && this.reactableFuel.get() + this.convertedFuel.get() >= 144.0;
    }

    public boolean canActivate() {
        if (!this.field_145850_b.field_72995_K && !this.validateStructure()) {
            return false;
        }
        if (this.reactorState.get() == ReactorState.BEYOND_HOPE) {
            return false;
        }
        return (this.reactorState.get() == ReactorState.WARMING_UP || this.reactorState.get() == ReactorState.STOPPING) && this.temperature.get() >= 2000.0 && (this.saturation.get() >= this.maxSaturation.get() / 2L && this.shieldCharge.get() >= this.maxShieldCharge.get() / 2.0 || this.reactorState.get() == ReactorState.STOPPING);
    }

    public boolean canStop() {
        if (this.reactorState.get() == ReactorState.BEYOND_HOPE) {
            return false;
        }
        return this.reactorState.get() == ReactorState.RUNNING || this.reactorState.get() == ReactorState.WARMING_UP;
    }

    public void chargeReactor() {
        if (this.field_145850_b.field_72995_K) {
            LogHelper.dev("Reactor: Start Charging");
            this.sendPacketToServer(output -> output.writeByte(0), 0);
        } else if (this.canCharge()) {
            LogHelper.dev("Reactor: Start Charging");
            this.reactorState.set((Enum)ReactorState.WARMING_UP);
        }
    }

    public void activateReactor() {
        if (this.field_145850_b.field_72995_K) {
            LogHelper.dev("Reactor: Activate");
            this.sendPacketToServer(output -> output.writeByte(1), 0);
        } else if (this.canActivate()) {
            LogHelper.dev("Reactor: Activate");
            this.reactorState.set((Enum)ReactorState.RUNNING);
        }
    }

    public void shutdownReactor() {
        if (this.field_145850_b.field_72995_K) {
            LogHelper.dev("Reactor: Shutdown");
            this.sendPacketToServer(output -> output.writeByte(2), 0);
        } else if (this.canStop()) {
            LogHelper.dev("Reactor: Shutdown");
            this.reactorState.set((Enum)ReactorState.STOPPING);
        }
    }

    public void toggleFailSafe() {
        if (this.field_145850_b.field_72995_K) {
            this.sendPacketToServer(output -> output.writeByte(3), 0);
        } else {
            this.failSafeMode.set(!this.failSafeMode.get());
        }
    }

    public void onComponentClicked(PlayerEntity player, TileReactorComponent component) {
        if (!this.field_145850_b.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
            this.sendPacketToClient((ServerPlayerEntity)player, output -> output.writePos(component.func_174877_v()), 1);
        }
    }

    @Nullable
    public Container createMenu(int currentWindowIndex, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerReactor(DEContent.container_reactor, currentWindowIndex, player.field_71071_by, this);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        byte func = data.readByte();
        if (id == 0 && func == 0) {
            this.chargeReactor();
        } else if (id == 0 && func == 1) {
            this.activateReactor();
        } else if (id == 0 && func == 2) {
            this.shutdownReactor();
        } else if (id == 0 && func == 3) {
            this.toggleFailSafe();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 1) {
            BlockPos pos = data.readPos();
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (tile instanceof TileReactorComponent && screen instanceof GuiReactor) {
                ((GuiReactor)screen).component = (TileReactorComponent)tile;
            }
        }
    }

    private void checkPlayerCollision() {
        PlayerEntity player = BrandonsCore.proxy.getClientPlayer();
        double distance = Math.min(Utils.getDistanceAtoB((Vec3D)new Vec3D((Entity)player).add(0.0, (double)player.func_70047_e(), 0.0), (Vec3D)Vec3D.getCenter((BlockPos)this.field_174879_c)), Utils.getDistanceAtoB((Vec3D)new Vec3D((Entity)player), (Vec3D)Vec3D.getCenter((BlockPos)this.field_174879_c)));
        if (distance < this.getCoreDiameter() / 2.0 + 0.5 && !player.func_175149_v()) {
            double dMod = 1.0 - distance / Math.max(0.1, this.getCoreDiameter() / 2.0 + 0.5);
            double offsetX = player.func_226277_ct_() - (double)this.field_174879_c.func_177958_n() + 0.5;
            double offsetY = player.func_226278_cu_() - (double)this.field_174879_c.func_177956_o() + 0.5;
            double offsetZ = player.func_226281_cx_() - (double)this.field_174879_c.func_177952_p() + 0.5;
            double m = 1.0 * dMod;
            player.func_70024_g(offsetX * m, offsetY * m, offsetZ * m);
        }
    }

    public void pokeCore(TileReactorComponent component, Direction pokeFrom) {
        LogHelper.dev("Reactor: Core Poked, StructValid: " + this.structureValid);
        if (this.structureValid.get()) {
            TileEntity tile;
            if (component instanceof TileReactorInjector && !component.isBound.get() && (tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[pokeFrom.func_176745_a()].get()))) == this) {
                this.componentPositions[pokeFrom.func_176745_a()].set(this.getOffsetVec(component.func_174877_v()));
                component.bindToCore(this);
                LogHelper.dev("Reactor: Injector Added!");
            }
            if (!this.validateStructure()) {
                this.structureValid.set(false);
                this.attemptInitialization();
            }
        } else {
            this.attemptInitialization();
        }
    }

    public void componentBroken(TileReactorComponent component, Direction componentSide) {
        if (!this.structureValid.get() || this.reactorState.get() == ReactorState.BEYOND_HOPE) {
            return;
        }
        if (component instanceof TileReactorInjector) {
            LogHelper.dev("Reactor: Component broken! (Injector)");
            TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[componentSide.func_176745_a()].get()));
            if (tile == component || tile == null) {
                LogHelper.dev("Reactor: -Removed");
                this.componentPositions[componentSide.func_176745_a()].get().set(0, 0, 0);
            }
        } else if (this.reactorState.get() != ReactorState.COLD) {
            LogHelper.dev("Reactor: Component broken, Structure Invalidated (Unsafe!!!!)");
            if (this.temperature.get() > 2000.0) {
                this.reactorState.set((Enum)ReactorState.BEYOND_HOPE);
            } else if (this.temperature.get() >= 350.0) {
                this.minimalBoom();
            } else {
                this.reactorState.set((Enum)ReactorState.INVALID);
            }
            this.structureValid.set(false);
        } else {
            LogHelper.dev("Reactor: Component broken, Structure Invalidated (Safe)");
            this.structureValid.set(false);
            this.reactorState.set((Enum)ReactorState.INVALID);
        }
    }

    public void checkBlockIntrusions() {
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        if (this.tick % 100 == 0) {
            double rad = this.getCoreDiameter() * 1.05 / 2.0;
            Iterable inRange = BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177963_a(-rad, -rad, -rad), (BlockPos)this.field_174879_c.func_177963_a(rad + 1.0, rad + 1.0, rad + 1.0));
            for (BlockPos p : inRange) {
                if (p.equals((Object)this.field_174879_c) || Utils.getDistanceAtoB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) - 0.5 >= rad || this.field_145850_b.func_175623_d(p) || this.blockIntrusions.containsKey(p)) continue;
                this.blockIntrusions.put(p.func_185334_h(), 0);
            }
        }
        if (this.blockIntrusions.size() > 0) {
            Iterator<Map.Entry<BlockPos, Integer>> i = this.blockIntrusions.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<BlockPos, Integer> entry = i.next();
                Vec3D iPos = new Vec3D(entry.getKey());
                if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                    ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197631_x, iPos.x + 0.5, iPos.y + 0.5, iPos.z + 0.5, 5, 0.5, 0.5, 0.5, 0.01);
                }
                entry.setValue(entry.getValue() + 1);
                if (entry.getValue() <= 100) continue;
                i.remove();
                this.field_145850_b.func_217379_c(2001, entry.getKey(), Block.func_196246_j((BlockState)this.field_145850_b.func_180495_p(entry.getKey())));
                this.field_145850_b.func_217377_a(entry.getKey(), false);
            }
            if (this.tick % 20 == 0 || this.field_145850_b.field_73012_v.nextInt(40) == 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
            }
        }
    }

    public void attemptInitialization() {
        LogHelper.dev("Reactor: Attempt Initialization");
        if (!this.findComponents()) {
            LogHelper.dev("Failed fo find components");
            return;
        }
        if (!this.checkStabilizerAxis()) {
            LogHelper.dev("Failed stabilizer check");
            return;
        }
        if (!this.bindComponents()) {
            LogHelper.dev("Failed fo bind components");
            return;
        }
        this.structureValid.set(true);
        if (this.reactorState.get() == ReactorState.INVALID) {
            if (this.temperature.get() <= 100.0) {
                this.reactorState.set((Enum)ReactorState.COLD);
            } else {
                this.reactorState.set((Enum)ReactorState.COOLING);
            }
        }
        LogHelper.dev("Reactor: Structure Successfully Initialized!\n");
    }

    public boolean findComponents() {
        LogHelper.dev("Reactor: Find Components");
        int stabilizersFound = 0;
        block0: for (Direction facing : Direction.values()) {
            this.componentPositions[facing.func_176745_a()].get().set(0, 0, 0);
            for (int i = 4; i < 8; ++i) {
                BlockPos searchPos = this.field_174879_c.func_177967_a(facing, i);
                if (this.field_145850_b.func_175623_d(searchPos)) continue;
                TileEntity searchTile = this.field_145850_b.func_175625_s(searchPos);
                LogHelper.dev("Reactor: -Found: " + searchTile);
                if (!(searchTile instanceof TileReactorComponent) || ((TileReactorComponent)searchTile).facing.get() != facing.func_176734_d()) continue block0;
                LogHelper.dev("Set " + facing.func_176745_a() + " " + this.getOffsetVec(searchPos));
                this.componentPositions[facing.func_176745_a()].set(this.getOffsetVec(searchPos));
                if (!(searchTile instanceof TileReactorStabilizer)) continue block0;
                ++stabilizersFound;
                continue block0;
            }
        }
        LogHelper.dev("Reactor: Find Components | found " + stabilizersFound + " Stabilizers");
        return stabilizersFound == 4;
    }

    public boolean checkStabilizerAxis() {
        LogHelper.dev("Reactor: Check Stabilizer Axis");
        for (Direction.Axis axis : Direction.Axis.values()) {
            boolean axisValid = true;
            for (Direction facing : FacingUtils.getFacingsAroundAxis((Direction.Axis)axis)) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[facing.func_176745_a()].get()));
                if (tile instanceof TileReactorStabilizer && ((TileReactorStabilizer)tile).facing.get() == facing.func_176734_d()) continue;
                axisValid = false;
                break;
            }
            if (!axisValid) continue;
            this.stabilizerAxis.set((Enum)axis);
            LogHelper.dev("Reactor: -Found Valid Axis: " + axis);
            return true;
        }
        return false;
    }

    public boolean bindComponents() {
        LogHelper.dev("Reactor: Binding Components");
        int stabilizersBound = 0;
        for (int i = 0; i < 6; ++i) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[i].get()));
            if (!(tile instanceof TileReactorComponent)) continue;
            ((TileReactorComponent)tile).bindToCore(this);
            if (!(tile instanceof TileReactorStabilizer)) continue;
            ++stabilizersBound;
        }
        return stabilizersBound == 4;
    }

    public boolean validateStructure() {
        LogHelper.dev("Reactor: Validate Structure");
        for (Direction facing : FacingUtils.getFacingsAroundAxis((Direction.Axis)((Direction.Axis)this.stabilizerAxis.get()))) {
            BlockPos pos = this.getOffsetPos(this.componentPositions[facing.func_176745_a()].get());
            if (!Utils.isAreaLoaded((World)this.field_145850_b, (BlockPos)pos, (ChunkHolder.LocationType)ChunkHolder.LocationType.TICKING)) {
                return true;
            }
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            LogHelper.dev("Reactor: Validate Stabilizer: " + tile);
            if (!(tile instanceof TileReactorStabilizer) || !((TileReactorStabilizer)tile).getCorePos().equals((Object)this.field_174879_c)) {
                LogHelper.dev("Reactor: Structure Validation Failed!!!");
                return false;
            }
            for (ManagedVec3I vec : this.componentPositions) {
                pos = this.getOffsetPos(vec.get());
                tile = this.field_145850_b.func_175625_s(pos);
                if (tile instanceof TileReactorInjector && !((TileReactorInjector)tile).isBound.get()) {
                    ((TileReactorInjector)tile).bindToCore(this);
                }
                if (!(tile instanceof TileReactorComponent) || !((TileReactorComponent)tile).getCorePos().equals((Object)this.field_174879_c) || ((TileReactorComponent)tile).isBound.get()) continue;
                LogHelper.warn("Detected a reactor component in an invalid state. This is likely due to a recent bug that has since been fixed. The state of this component will now be corrected.");
                ((TileReactorComponent)tile).bindToCore(this);
            }
        }
        LogHelper.dev("Reactor: Structure Validated!");
        return true;
    }

    private void minimalBoom() {
        BlockState lava = Blocks.field_150353_l.func_176223_P();
        Vec3D vec = Vec3D.getCenter((BlockPos)this.field_174879_c);
        this.field_145850_b.func_217377_a(this.field_174879_c, false);
        this.field_145850_b.func_217385_a(null, vec.x, vec.y, vec.z, 8.0f, Explosion.Mode.BREAK);
        int c = 25 + this.field_145850_b.field_73012_v.nextInt(25);
        for (int i = 0; i < c; ++i) {
            FallingBlockEntity entity = new FallingBlockEntity(this.field_145850_b, vec.x, vec.y, vec.z, lava);
            entity.field_145812_b = 1;
            entity.field_145813_c = false;
            double vMod = 0.5 + 2.0 * this.field_145850_b.field_73012_v.nextDouble();
            entity.func_70024_g((this.field_145850_b.field_73012_v.nextDouble() - 0.5) * vMod, this.field_145850_b.field_73012_v.nextDouble() / 1.5 * vMod, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * vMod);
            this.field_145850_b.func_217376_c((Entity)entity);
        }
    }

    private BlockPos getOffsetPos(Vec3I vec) {
        return this.field_174879_c.func_177973_b((Vector3i)vec.getPos());
    }

    private Vec3I getOffsetVec(BlockPos offsetPos) {
        return new Vec3I(this.field_174879_c.func_177973_b((Vector3i)offsetPos));
    }

    public TileReactorComponent getComponent(Direction facing) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[facing.func_176745_a()].get()));
        if (tile instanceof TileReactorComponent && ((TileReactorComponent)tile).facing.get() == facing.func_176734_d()) {
            return (TileReactorComponent)tile;
        }
        return null;
    }

    public long injectEnergy(long energy) {
        long received = 0L;
        if (this.reactorState.get() == ReactorState.WARMING_UP) {
            if (!this.startupInitialized.get()) {
                return 0L;
            }
            if (this.shieldCharge.get() < this.maxShieldCharge.get() / 2.0) {
                received = Math.min(energy, (long)((int)(this.maxShieldCharge.get() / 2.0) - (int)this.shieldCharge.get() + 1));
                this.shieldCharge.add((double)received);
                if (this.shieldCharge.get() > this.maxShieldCharge.get() / 2.0) {
                    this.shieldCharge.set(this.maxShieldCharge.get() / 2.0);
                }
            } else if (this.saturation.get() < this.maxSaturation.get() / 2L) {
                received = Math.min(energy, this.maxSaturation.get() / 2L - this.saturation.get());
                this.saturation.add(received);
            } else if (this.temperature.get() < 2000.0) {
                received = energy;
                this.temperature.add((double)received / (1000.0 + this.reactableFuel.get() * 10.0));
                if (this.temperature.get() > 2500.0) {
                    this.temperature.set(2500.0);
                }
            }
        } else if (this.reactorState.get() == ReactorState.RUNNING || this.reactorState.get() == ReactorState.STOPPING) {
            double tempFactor = 1.0;
            if (this.temperature.get() > 15000.0) {
                tempFactor = 1.0 - Math.min(1.0, (this.temperature.get() - 15000.0) / 10000.0);
            }
            this.shieldCharge.add(Math.min((double)energy * (1.0 - this.shieldCharge.get() / this.maxShieldCharge.get()), this.maxShieldCharge.get() - this.shieldCharge.get()) * tempFactor);
            if (this.shieldCharge.get() > this.maxShieldCharge.get()) {
                this.shieldCharge.set(this.maxShieldCharge.get());
            }
            return energy;
        }
        return received;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 40960.0;
    }

    public double getCoreDiameter() {
        double volume = (this.reactableFuel.get() + this.convertedFuel.get()) / 1296.0;
        double diameter = Math.cbrt((volume *= 1.0 + this.temperature.get() / 10000.0 * 10.0) / Math.PI) * 2.0;
        return Math.max(0.5, diameter);
    }

    public static enum ReactorState {
        INVALID(false),
        COLD(false),
        WARMING_UP(true),
        RUNNING(true),
        STOPPING(true),
        COOLING(true),
        BEYOND_HOPE(true);

        private final boolean shieldActive;

        private ReactorState(boolean shieldActive) {
            this.shieldActive = shieldActive;
        }

        public boolean isShieldActive() {
            return this.shieldActive;
        }

        @OnlyIn(value=Dist.CLIENT)
        public String localize() {
            TextFormatting[] colours = new TextFormatting[]{TextFormatting.RED, TextFormatting.DARK_AQUA, TextFormatting.LIGHT_PURPLE, TextFormatting.GREEN, TextFormatting.LIGHT_PURPLE, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_RED};
            return colours[this.ordinal()] + I18n.func_135052_a((String)("gui.reactor.status." + this.name().toLowerCase(Locale.ENGLISH) + ".info"), (Object[])new Object[0]);
        }
    }

    public static class Roller {
        public Vec3D pos;
        public Vec3D lastPos;
        public double direction;
        private World world;
        private double diameter;
        public double fallVelocity = 0.0;
        public double speed = 0.0;
        public int age = 0;

        public Roller(Vec3D pos, World world, double diameter) {
            this.pos = pos;
            this.lastPos = pos.copy();
            this.direction = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            this.world = world;
            this.diameter = diameter / 2.0 + 1.0;
            this.speed = -0.3;
        }

        public void update() {
            int y;
            this.lastPos = this.pos.copy();
            double x = Math.cos(this.direction);
            double z = Math.sin(this.direction);
            BlockPos p = this.pos.getPos();
            if (this.world.func_175623_d(p) || this.world.func_180495_p(p).func_177230_c() == DEContent.reactor_core) {
                while ((this.world.func_175623_d(p) || this.world.func_180495_p(p).func_177230_c() == DEContent.reactor_core) && p.func_177956_o() > 0) {
                    p = p.func_177977_b();
                }
            } else {
                while (!this.world.func_175623_d(p)) {
                    p = p.func_177984_a();
                }
            }
            this.fallVelocity = this.pos.y > (double)(y = p.func_177956_o()) + this.diameter ? (this.fallVelocity += 0.1) : 0.0;
            this.pos.y -= this.fallVelocity;
            if (this.pos.y < (double)y + this.diameter && this.fallVelocity > 0.0) {
                this.pos.y = (double)y + this.diameter;
            }
            if ((double)y + this.diameter > this.pos.y) {
                this.pos.y += ((double)y + this.diameter - this.pos.y) * Math.max(this.speed, 0.1);
            }
            if (this.speed < 0.5 && this.fallVelocity == 0.0) {
                this.speed += 0.01;
            }
            if (this.speed > 0.0) {
                this.pos.add(x * this.speed, 0.0, z * this.speed);
            }
            ++this.age;
        }
    }
}

