/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStabilizedSpawner;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.MobSoul;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class StabilizedSpawner
extends BlockBCore {
    public StabilizedSpawner(AbstractBlock.Properties properties) {
        super(properties);
        this.setMobResistant();
    }

    public boolean isBlockFullCube() {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileStabilizedSpawner();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void setStackData(ItemStack stack, String entityString, TileStabilizedSpawner.SpawnerTier tier) {
        this.setStackDataTier(stack, tier);
        this.setStackDataEntity(stack, entityString);
    }

    public void setStackDataTier(ItemStack stack, TileStabilizedSpawner.SpawnerTier tier) {
        CompoundNBT managedData = stack.func_190925_c("bc_tile_data").func_74775_l("bc_managed_data");
        managedData.func_74774_a("spawner_tier", (byte)tier.ordinal());
        stack.func_190925_c("bc_tile_data").func_218657_a("bc_managed_data", (INBT)managedData);
    }

    public void setStackDataEntity(ItemStack stack, String entityString) {
        if (entityString != null) {
            ItemStack soul = new ItemStack((IItemProvider)DEContent.mob_soul);
            DEContent.mob_soul.setEntity(MobSoul.getCachedRegName(entityString), soul);
            CompoundNBT managedData = stack.func_190925_c("bc_tile_data").func_74775_l("bc_managed_data");
            stack.func_190925_c("bc_tile_data").func_74775_l("bc_managed_data");
            managedData.func_218657_a("mob_soul", (INBT)soul.serializeNBT());
            stack.func_190925_c("bc_tile_data").func_218657_a("bc_managed_data", (INBT)managedData);
        }
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }
}

