/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.SubHitVoxelShape;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyTransfuser;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class EnergyTransfuser
extends BlockBCore {
    private static final VoxelShape SHAPE;

    public EnergyTransfuser(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean isBlockFullCube() {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEnergyTransfuser();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    static {
        double p = 0.0625;
        double hp = p / 2.0;
        IndexedCuboid6 BASE = new IndexedCuboid6((Object)-1, new Cuboid6(hp, hp, hp, 1.0 - hp, 1.0 - hp, 1.0 - hp));
        VoxelShape BASE_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)BASE.aabb());
        ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
        cuboids.add(BASE);
        Cuboid6 interactFace = new Cuboid6(p * 3.0, p * 3.0, hp / 2.0, 1.0 - p * 3.0, 1.0 - p * 3.0, p);
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        int i = 0;
        for (Direction dir : dirs) {
            Transformation rotation = Rotation.quarterRotations[dir.func_176736_b() ^ 2].at(Vector3.CENTER);
            cuboids.add(new IndexedCuboid6((Object)i, interactFace.copy().apply(rotation)));
            ++i;
        }
        SHAPE = new SubHitVoxelShape(BASE_SHAPE, cuboids);
    }
}

