/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import net.minecraft.item.ItemStack;

public class EnergyEntity
extends ModuleEntity {
    private long energy = 0L;

    public EnergyEntity(Module<?> module) {
        super(module);
    }

    @Override
    public void onRemoved(ModuleContext context) {
        super.onRemoved(context);
        IOPStorageModifiable storage = context.getOpStorage();
        if (this.energy > 0L && storage instanceof IOPStorageModifiable) {
            storage.modifyEnergyStored(-this.energy);
        } else if (this.energy > 0L && storage != null) {
            storage.extractOP(this.energy, false);
        }
    }

    @Override
    public void onInstalled(ModuleContext context) {
        super.onInstalled(context);
        IOPStorageModifiable storage = context.getOpStorage();
        if (this.energy > 0L && storage instanceof IOPStorageModifiable) {
            storage.modifyEnergyStored(this.energy);
        } else if (this.energy > 0L && storage != null) {
            storage.receiveOP(this.energy, false);
        }
    }

    @Override
    public void writeToItemStack(ItemStack stack, ModuleContext context) {
        super.writeToItemStack(stack, context);
        IOPStorageModifiable storage = context.getOpStorage();
        if (storage != null) {
            long moduleCap = ModuleTypes.ENERGY_STORAGE.getData(this.module).getCapacity();
            long newCapacity = storage.getMaxOPStored() - moduleCap;
            if (newCapacity < (long)storage.getEnergyStored()) {
                this.energy = Math.min((long)storage.getEnergyStored() - newCapacity, moduleCap);
                stack.func_196082_o().func_74772_a("stored_energy", this.energy);
            }
        }
    }

    @Override
    public void readFromItemStack(ItemStack stack, ModuleContext context) {
        super.readFromItemStack(stack, context);
        if (stack.func_77942_o()) {
            this.energy = stack.func_196082_o().func_74763_f("stored_energy");
        }
    }
}

