/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AutoFeedEntity
extends ModuleEntity {
    private BooleanProperty consumeFood = new BooleanProperty("feed_mod.consume_food", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
    private float storedFood = 0.0f;

    public AutoFeedEntity(Module<AutoFeedData> module) {
        super(module);
        this.addProperty(this.consumeFood);
        this.savePropertiesToItem = true;
    }

    @Override
    public void tick(ModuleContext context) {
        LivingEntity entity;
        AutoFeedData data = (AutoFeedData)this.module.getData();
        if (context instanceof StackModuleContext && (entity = ((StackModuleContext)context).getEntity()) instanceof ServerPlayerEntity && entity.field_70173_aa % 10 == 0 && ((StackModuleContext)context).isEquipped()) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if ((double)this.storedFood < data.getFoodStorage() && this.consumeFood.getValue()) {
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    double val;
                    double rem;
                    Food food;
                    if (stack.func_190926_b() || !stack.func_222117_E() || (food = stack.func_77973_b().func_219967_s()) == null || food.func_221466_a() <= 0 || !food.func_221464_f().isEmpty() || !((rem = (double)this.storedFood + (val = (double)((float)food.func_221466_a() + food.func_221469_b())) - data.getFoodStorage()) <= val * 0.25)) continue;
                    this.storedFood = (float)Math.min((double)this.storedFood + val, data.getFoodStorage());
                    entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.25f, 0.95f + entity.field_70170_p.field_73012_v.nextFloat() * 0.1f);
                    stack.func_190918_g(1);
                    break;
                }
            }
            FoodStats foodStats = player.func_71024_bL();
            if (this.storedFood > 0.0f && (foodStats.func_75116_a() < 20 || foodStats.func_75115_e() < 20.0f)) {
                double maxSat;
                TechLevel tech = this.module.getModuleTechLevel();
                double d = maxSat = entity.field_70173_aa % 20 == 0 && tech == TechLevel.DRACONIC ? 20.0 : 1.0;
                if (foodStats.func_75121_c() && this.storedFood > 1.0f) {
                    foodStats.func_75122_a((int)this.consumeFood(Math.min(1, 20 - foodStats.func_75116_a())), 0.0f);
                } else if ((double)foodStats.func_75115_e() < maxSat && this.storedFood > 0.0f) {
                    foodStats.field_75125_b = (float)((double)foodStats.field_75125_b + this.consumeFood(Math.min(1.0, maxSat - (double)foodStats.func_75115_e())));
                }
            }
        }
    }

    private double consumeFood(double amount) {
        amount = Math.min(amount, (double)this.storedFood);
        this.storedFood = (float)((double)this.storedFood - amount);
        return amount;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderSlotOverlay(IRenderTypeBuffer getter, Minecraft mc, int x, int y, int width, int height, double mouseX, double mouseY, boolean mouseOver, float partialTicks) {
        IVertexBuilder builder = getter.getBuffer(BCSprites.GUI_TYPE);
        AutoFeedData data = (AutoFeedData)this.module.getData();
        double progress = (double)this.storedFood / data.getFoodStorage();
        progress = (int)(progress * 21.0);
        progress = 20.0 - progress - 1.0;
        for (int i = 0; i < 10; ++i) {
            float size = (float)(width - 3) / 10.0f;
            GuiHelperOld.drawSprite((IVertexBuilder)builder, (float)((float)(x + 1) + (float)i * size), (float)((float)(y + height) - size - 2.0f), (float)(size + 1.0f), (float)(size + 1.0f), (TextureAtlasSprite)BCSprites.get((String)"bars/food_empty").func_229314_c_(), (double)0.0);
            if (!(progress / 2.0 <= (double)i)) continue;
            if (progress / 2.0 < (double)i) {
                GuiHelperOld.drawSprite((IVertexBuilder)builder, (float)((float)(x + 1) + (float)i * size), (float)((float)(y + height) - size - 2.0f), (float)(size + 1.0f), (float)(size + 1.0f), (TextureAtlasSprite)BCSprites.get((String)"bars/food_full").func_229314_c_(), (double)0.0);
                continue;
            }
            GuiHelperOld.drawSprite((IVertexBuilder)builder, (float)((float)(x + 1) + (float)i * size), (float)((float)(y + height) - size - 2.0f), (float)(size + 1.0f), (float)(size + 1.0f), (TextureAtlasSprite)BCSprites.get((String)"bars/food_half").func_229314_c_(), (double)0.0);
        }
    }

    @Override
    public void addToolTip(List<ITextComponent> list) {
        list.add((ITextComponent)new TranslationTextComponent("module.draconicevolution.auto_feed.stored").func_240699_a_(TextFormatting.GRAY).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("module.draconicevolution.auto_feed.stored.value", new Object[]{(int)this.storedFood}).func_240699_a_(TextFormatting.DARK_GREEN)));
    }

    @Override
    public void writeToItemStack(ItemStack stack, ModuleContext context) {
        super.writeToItemStack(stack, context);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74776_a("food", this.storedFood);
    }

    @Override
    public void readFromItemStack(ItemStack stack, ModuleContext context) {
        super.readFromItemStack(stack, context);
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_196082_o();
            this.storedFood = nbt.func_74760_g("food");
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74776_a("food", this.storedFood);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.storedFood = compound.func_74760_g("food");
    }
}

