/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.init.EquipCfg;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ShieldData
implements ModuleData<ShieldData> {
    private final int shieldCapacity;
    private final double shieldRecharge;

    public ShieldData(int shieldCapacity, double shieldRecharge) {
        this.shieldCapacity = shieldCapacity;
        this.shieldRecharge = shieldRecharge;
    }

    public int getShieldCapacity() {
        return this.shieldCapacity;
    }

    public double getShieldRecharge() {
        return this.shieldRecharge;
    }

    @Override
    public ShieldData combine(ShieldData other) {
        return new ShieldData(this.shieldCapacity + other.shieldCapacity, this.shieldRecharge + other.shieldRecharge);
    }

    @Override
    public void addInformation(Map<ITextComponent, ITextComponent> map, ModuleContext context, boolean stack) {
        if (this.shieldCapacity > 0) {
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.shield_capacity.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.shield_capacity.value", new Object[]{this.shieldCapacity}));
        }
        if (this.shieldRecharge > 0.0) {
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.shield_recharge.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.shield_recharge.value", new Object[]{ModuleData.round(this.shieldRecharge * 20.0, 10.0), ModuleData.round((double)this.shieldCapacity / this.shieldRecharge / 20.0, 10.0), (int)Math.max(this.shieldRecharge * (double)EquipCfg.energyShieldChg, (double)EquipCfg.energyShieldChg)}));
        }
        if (this.shieldCapacity > 0) {
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.shield_passive.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.shield_passive.value", new Object[]{(double)Math.round((double)(this.shieldCapacity * this.shieldCapacity) * EquipCfg.shieldPassiveModifier * 10.0) / 10.0}));
        }
    }
}

