/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionDataTransfer;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FusionRecipe
implements IFusionRecipe {
    private ResourceLocation id;
    private final ItemStack result;
    private final Ingredient catalyst;
    private final long totalEnergy;
    private final TechLevel techLevel;
    private final Collection<FusionIngredient> ingredients;

    public FusionRecipe(ResourceLocation id, ItemStack result, Ingredient catalyst, long totalEnergy, TechLevel techLevel, Collection<FusionIngredient> ingredients) {
        this.id = id;
        this.result = result;
        this.catalyst = catalyst;
        this.totalEnergy = totalEnergy;
        this.techLevel = techLevel;
        this.ingredients = ingredients;
    }

    @Override
    public TechLevel getRecipeTier() {
        return this.techLevel;
    }

    @Override
    public long getEnergyCost() {
        return this.totalEnergy;
    }

    @Override
    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients.stream().map(fusionIngredient -> ((FusionIngredient)fusionIngredient).ingredient).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    @Override
    public List<IFusionRecipe.IFusionIngredient> fusionIngredients() {
        return ImmutableList.copyOf(this.ingredients);
    }

    @Override
    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public ItemStack assemble(IFusionInventory inv) {
        ItemStack stack = this.result.func_77946_l();
        if (stack.func_77973_b() instanceof IFusionDataTransfer) {
            ((IFusionDataTransfer)stack.func_77973_b()).transferIngredientData(stack, inv);
        }
        return stack;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return DraconicAPI.FUSION_RECIPE_SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FusionRecipe> {
        public FusionRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            Ingredient catalyst = CraftingHelper.getIngredient((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"catalyst"));
            ArrayList<FusionIngredient> fusionIngredients = new ArrayList<FusionIngredient>();
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (JsonElement element : ingredients) {
                Ingredient ingredient = element.isJsonObject() && element.getAsJsonObject().has("ingredient") ? CraftingHelper.getIngredient((JsonElement)element.getAsJsonObject().get("ingredient")) : CraftingHelper.getIngredient((JsonElement)element);
                boolean isConsumed = !element.isJsonObject() || JSONUtils.func_151209_a((JsonObject)element.getAsJsonObject(), (String)"consume", (boolean)true);
                fusionIngredients.add(new FusionIngredient(ingredient, isConsumed));
            }
            long totalEnergy = JSONUtils.func_226161_m_((JsonObject)json, (String)"total_energy");
            TechLevel techLevel = TechLevel.valueOf((String)JSONUtils.func_151219_a((JsonObject)json, (String)"tier", (String)TechLevel.DRACONIUM.name()));
            return new FusionRecipe(id, result, catalyst, totalEnergy, techLevel, fusionIngredients);
        }

        public FusionRecipe fromNetwork(ResourceLocation id, PacketBuffer buffer) {
            ItemStack result = buffer.func_150791_c();
            Ingredient catalyst = Ingredient.func_199566_b((PacketBuffer)buffer);
            int count = buffer.readByte();
            ArrayList<FusionIngredient> fusionIngredients = new ArrayList<FusionIngredient>();
            for (int i = 0; i < count; ++i) {
                fusionIngredients.add(FusionIngredient.read(buffer));
            }
            long totalEnergy = buffer.readLong();
            TechLevel techLevel = TechLevel.VALUES[MathHelper.func_76125_a((int)buffer.readByte(), (int)0, (int)(TechLevel.values().length - 1))];
            return new FusionRecipe(id, result, catalyst, totalEnergy, techLevel, fusionIngredients);
        }

        public void toNetwork(PacketBuffer buffer, FusionRecipe recipe) {
            buffer.writeItemStack(recipe.result, false);
            recipe.catalyst.func_199564_a(buffer);
            buffer.writeByte(recipe.ingredients.size());
            for (FusionIngredient ingredient : recipe.ingredients) {
                ingredient.write(buffer);
            }
            buffer.writeLong(recipe.totalEnergy);
            buffer.writeByte(((FusionRecipe)recipe).techLevel.index);
        }
    }

    public static class FusionIngredient
    implements IFusionRecipe.IFusionIngredient {
        private final Ingredient ingredient;
        private final boolean consume;

        public FusionIngredient(Ingredient ingredient, boolean consume) {
            this.ingredient = ingredient;
            this.consume = consume;
        }

        @Override
        public Ingredient get() {
            return this.ingredient;
        }

        @Override
        public boolean consume() {
            return this.consume;
        }

        protected void write(PacketBuffer buffer) {
            buffer.writeBoolean(this.consume);
            this.ingredient.func_199564_a(buffer);
        }

        protected static FusionIngredient read(PacketBuffer buffer) {
            boolean consume = buffer.readBoolean();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new FusionIngredient(ingredient, consume);
        }
    }
}

