/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class PropertyProviderImpl
implements PropertyProvider {
    private UUID providerID = null;
    private String providerName;
    private Map<String, ConfigProperty> propertyMap = new HashMap<String, ConfigProperty>();

    public PropertyProviderImpl(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public UUID getProviderID() {
        if (this.providerID == null) {
            this.regenProviderID();
        }
        return this.providerID;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void regenProviderID() {
        this.providerID = UUID.randomUUID();
    }

    @Override
    public Collection<ConfigProperty> getProperties() {
        return this.propertyMap.values();
    }

    @Override
    @Nullable
    public ConfigProperty getProperty(String propertyID) {
        return this.propertyMap.get(propertyID);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("provider_id", this.getProviderID());
        CompoundNBT properties = new CompoundNBT();
        this.propertyMap.forEach((name, property) -> properties.func_218657_a(name, (INBT)property.serializeNBT()));
        nbt.func_218657_a("properties", (INBT)properties);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_186855_b("provider_id")) {
            this.providerID = nbt.func_186857_a("provider_id");
        }
        CompoundNBT properties = nbt.func_74775_l("properties");
        this.propertyMap.forEach((name, property) -> property.deserializeNBT(properties.func_74775_l(name)));
    }
}

