/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectSummonSteed
extends AbstractEffect {
    public static EffectSummonSteed INSTANCE = new EffectSummonSteed();

    private EffectSummonSteed() {
        super("summon_steed", "Summon Steed");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (!this.canSummon(shooter)) {
            return;
        }
        int ticks = (int)(20.0 * ((double)((Integer)this.GENERIC_INT.get()).intValue() + (double)((Integer)this.EXTEND_TIME.get()).intValue() * spellStats.getDurationMultiplier()));
        Vector3d hit = rayTraceResult.func_216347_e();
        for (int i = 0; i < 1 + spellStats.getBuffCount(AugmentAOE.INSTANCE); ++i) {
            SummonHorse horse = new SummonHorse(ModEntities.SUMMON_HORSE, world);
            horse.func_70107_b(hit.func_82615_a(), hit.func_82617_b(), hit.func_82616_c());
            horse.ticksLeft = ticks;
            horse.func_110263_g((PlayerEntity)shooter);
            horse.setOwnerID(shooter.func_110124_au());
            horse.getHorseInventory().func_70299_a(0, new ItemStack((IItemProvider)Items.field_151141_av));
            horse.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
            this.summonLivingEntity(rayTraceResult, world, shooter, spellStats, spellContext, horse);
        }
        this.applySummoningSickness(shooter, 600);
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addExtendTimeConfig(builder, 120);
        this.addGenericInt(builder, 300, "Base duration in seconds", "duration");
    }

    @Override
    public int getManaCost() {
        return 100;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.ONE;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Summons a saddled horse that will vanish after a few minutes. AOE will increase the amount summoned, while Extend Time will increase the duration of the summon. Applies Summoning Sickness to the caster, and cannot be cast while afflicted by this Sickness.";
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151116_aA;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.CONJURATION);
    }
}

