/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EffectPickup
extends AbstractEffect {
    public static EffectPickup INSTANCE = new EffectPickup();

    private EffectPickup() {
        super("pickup", "Item Pickup");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos pos = new BlockPos(rayTraceResult.func_216347_e());
        int expansion = 2 + spellStats.getBuffCount(AugmentAOE.INSTANCE);
        List entityList = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos.func_177965_g(expansion).func_177964_d(expansion).func_177981_b(expansion), pos.func_177985_f(expansion).func_177970_e(expansion).func_177979_c(expansion)));
        for (ItemEntity i : entityList) {
            if (this.isRealPlayer(shooter) && spellContext.castingTile == null) {
                ItemStack stack = i.func_92059_d();
                PlayerEntity player = (PlayerEntity)shooter;
                VoidJar.tryVoiding(player, stack);
                if (player.func_191521_c(stack)) continue;
                i.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                continue;
            }
            if (shooter instanceof IPickupResponder) {
                i.func_92058_a(((IPickupResponder)shooter).onPickup(i.func_92059_d()));
                continue;
            }
            if (!(spellContext.castingTile instanceof IPickupResponder)) continue;
            i.func_92058_a(((IPickupResponder)spellContext.castingTile).onPickup(i.func_92059_d()));
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return true;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Picks up nearby items in a medium radius where this spell is activated. The range may be expanded with AOE.";
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221862_eo;
    }

    @Override
    public int getManaCost() {
        return 10;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

