/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.common.block.tile.LightTile;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectLight
extends AbstractEffect {
    public static EffectLight INSTANCE = new EffectLight();

    private EffectLight() {
        super("light", "Conjure Magelight");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (rayTraceResult.func_216348_a() instanceof ILightable) {
            ((ILightable)rayTraceResult.func_216348_a()).onLight((RayTraceResult)rayTraceResult, world, shooter, spellStats, spellContext);
        }
        if (!(rayTraceResult.func_216348_a() instanceof LivingEntity)) {
            return;
        }
        if (shooter == null || !shooter.equals((Object)rayTraceResult.func_216348_a())) {
            this.applyConfigPotion((LivingEntity)rayTraceResult.func_216348_a(), Effects.field_188423_x, spellStats);
        }
        this.applyConfigPotion((LivingEntity)rayTraceResult.func_216348_a(), Effects.field_76439_r, spellStats);
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos pos = rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b());
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerWorld)world), world, pos)) {
            return;
        }
        if (world.func_175625_s(rayTraceResult.func_216350_a()) instanceof ILightable) {
            ((ILightable)world.func_175625_s(rayTraceResult.func_216350_a())).onLight((RayTraceResult)rayTraceResult, world, shooter, spellStats, spellContext);
            return;
        }
        if (world.func_180495_p(pos).func_185904_a().func_76222_j() && world.func_226663_a_(BlockRegistry.LIGHT_BLOCK.func_176223_P(), pos, ISelectionContext.func_216374_a((Entity)ANFakePlayer.getPlayer((ServerWorld)world)))) {
            world.func_175656_a(pos, (BlockState)BlockRegistry.LIGHT_BLOCK.func_176223_P().func_206870_a(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.max(0, Math.min(15, 14 + (int)spellStats.getAmpMultiplier())))));
            LightTile tile = (LightTile)world.func_175625_s(pos);
            if (tile != null) {
                tile.red = spellContext.colors.r;
                tile.green = spellContext.colors.g;
                tile.blue = spellContext.colors.b;
            }
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 30);
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    @Override
    public int getManaCost() {
        return 25;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_222111_pQ;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDurationDown.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "If cast on a block, a permanent light source is created. May be amplified up to Glowstone brightness, or Dampened for a lower light level. When cast on yourself, you will receive night vision. When cast on other entities, they will receive Night Vision and Glowing.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.CONJURATION);
    }
}

