/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.ANExplosion;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;

public class EffectExplosion
extends AbstractEffect {
    public static EffectExplosion INSTANCE = new EffectExplosion();
    public ForgeConfigSpec.DoubleValue BASE;
    public ForgeConfigSpec.DoubleValue AOE_BONUS;
    public ForgeConfigSpec.DoubleValue AMP_DAMAGE;

    private EffectExplosion() {
        super("explosion", "Explosion");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        Vector3d vec = this.safelyGetHitPos(rayTraceResult);
        double intensity = (Double)this.BASE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier() + (Double)this.AOE_BONUS.get() * (double)spellStats.getBuffCount(AugmentAOE.INSTANCE);
        int dampen = spellStats.getBuffCount(AugmentDampen.INSTANCE);
        Explosion.Mode mode = dampen > 0 ? Explosion.Mode.NONE : Explosion.Mode.DESTROY;
        mode = spellStats.hasBuff(AugmentExtract.INSTANCE) ? Explosion.Mode.BREAK : mode;
        this.explode(world, (Entity)shooter, null, null, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (float)(intensity -= 0.5 * (double)dampen), false, mode, spellStats.getAmpMultiplier());
    }

    public Explosion explode(World world, @Nullable Entity e, @Nullable DamageSource source, @Nullable ExplosionContext context, double x, double y, double z, float radius, boolean p_230546_11_, Explosion.Mode p_230546_12_, double amp) {
        ANExplosion explosion = new ANExplosion(world, e, source, context, x, y, z, radius, p_230546_11_, p_230546_12_, amp);
        explosion.baseDamage = (Double)this.DAMAGE.get();
        explosion.ampDamageScalar = (Double)this.AMP_DAMAGE.get();
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (p_230546_12_ == Explosion.Mode.NONE) {
            explosion.func_180342_d();
        }
        for (PlayerEntity serverplayerentity : world.func_217369_A()) {
            if (!(serverplayerentity.func_70092_e(x, y, z) < 4096.0)) continue;
            ((ServerPlayerEntity)serverplayerentity).field_71135_a.func_147359_a((IPacket)new SExplosionPacket(x, y, z, radius, explosion.func_180343_e(), (Vector3d)explosion.func_77277_b().get(serverplayerentity)));
        }
        return explosion;
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addAmpConfig(builder, 0.5);
        this.BASE = builder.comment("Explosion base intensity").defineInRange("base", 0.75, 0.0, 100.0);
        this.AOE_BONUS = builder.comment("AOE intensity bonus").defineInRange("aoe_bonus", 1.5, 0.0, 100.0);
        this.addDamageConfig(builder, 6.0);
        this.AMP_DAMAGE = builder.comment("Additional damage per amplify").defineInRange("amp_damage", 2.5, 0.0, 2.147483647E9);
    }

    @Override
    public int getManaCost() {
        return 200;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221649_bM;
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentExtract.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Causes an explosion at the location. Amplify increases the damage and size by a small amount, while AOE will increase the size of the explosion by a large amount, but not damage.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_FIRE);
    }
}

