/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class RitualWarp
extends AbstractRitual {
    @Override
    protected void tick() {
        World world = this.getWorld();
        if (world.field_72995_K) {
            BlockPos pos = this.getPos();
            for (int i = 0; i < 100; ++i) {
                Vector3d particlePos = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c(0.5, 0.0, 0.5);
                particlePos = particlePos.func_178787_e(ParticleUtil.pointInSphere().func_216372_d(5.0, 5.0, 5.0));
                world.func_195594_a(ParticleLineData.createData(this.getCenterColor()), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
            }
        }
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L) {
            this.incrementProgress();
            if (this.getProgress() >= 3) {
                List entities = this.getWorld().func_217357_a(LivingEntity.class, new AxisAlignedBB(this.getPos()).func_186662_g(5.0));
                ItemStack i = this.getConsumedItems().get(0);
                BlockPos b = WarpScroll.getPos(i);
                for (Entity a : entities) {
                    if (b == null) continue;
                    a.func_70634_a((double)b.func_177958_n(), (double)b.func_177956_o(), (double)b.func_177952_p());
                }
                if (b != null) {
                    world.func_184133_a(null, b, SoundEvents.field_187812_eh, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
                this.setFinished();
            }
        }
    }

    @Override
    public String getLangName() {
        return "Warping";
    }

    @Override
    public String getLangDescription() {
        return "Warps all nearby entities to the location on a warp scroll. Before starting the ritual, you must first augment the ritual with an inscribed Warp Scroll.";
    }

    @Override
    public ParticleColor getCenterColor() {
        return super.getCenterColor();
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return this.getConsumedItems().isEmpty() && stack.func_77973_b() instanceof WarpScroll && WarpScroll.getPos(stack) != null && !WarpScroll.getPos(stack).equals((Object)new BlockPos(0, 0, 0));
    }

    @Override
    public boolean canStart() {
        return this.getConsumedItems().size() > 0;
    }

    @Override
    public String getID() {
        return "warping";
    }
}

