/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.mixin.ExpInvokerMixin;
import com.hollingsworth.arsnouveau.setup.EntityTags;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RitualDisintegration
extends AbstractRitual {
    @Override
    public void onStart() {
        super.onStart();
        if (this.tile == null) {
            return;
        }
    }

    @Override
    protected void tick() {
        World world = this.getWorld();
        if (world.field_72995_K) {
            BlockPos pos = this.getPos();
            for (int i = 0; i < 100; ++i) {
                Vector3d particlePos = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c(0.5, 0.0, 0.5);
                particlePos = particlePos.func_178787_e(ParticleUtil.pointInSphere().func_216372_d(5.0, 5.0, 5.0));
                world.func_195594_a(ParticleLineData.createData(this.getCenterColor()), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
            }
        }
        if (!world.field_72995_K && world.func_82737_E() % 60L == 0L) {
            boolean didWorkOnce = false;
            List entityList = world.func_175647_a(LivingEntity.class, new AxisAlignedBB(this.getPos()).func_186662_g(5.0), m -> (m.getClassification(false).equals((Object)EntityClassification.MONSTER) || m.func_200600_R().func_220341_a(EntityTags.DISINTEGRATION_WHITELIST)) && !(m instanceof PlayerEntity));
            for (LivingEntity m2 : entityList) {
                int numLesser;
                int numGreater;
                int exp;
                if (m2.func_200600_R().func_220341_a(EntityTags.DISINTEGRATION_BLACKLIST)) continue;
                m2.func_70106_y();
                if (!m2.field_70128_L) continue;
                ExpInvokerMixin invoker = (ExpInvokerMixin)m2;
                ParticleUtil.spawnPoof((ServerWorld)world, m2.func_233580_cy_());
                if (!invoker.an_shouldDropExperience() || (exp = invoker.an_getExperienceReward((PlayerEntity)ANFakePlayer.getPlayer((ServerWorld)this.getWorld())) * 2) <= 0) continue;
                if ((exp -= (numGreater = exp / 12) * 12) - (numLesser = exp / 3) * 3 > 0) {
                    ++numLesser;
                }
                world.func_217376_c((Entity)new ItemEntity(world, (double)m2.func_233580_cy_().func_177958_n(), (double)m2.func_233580_cy_().func_177956_o(), (double)m2.func_233580_cy_().func_177952_p(), new ItemStack((IItemProvider)ItemsRegistry.GREATER_EXPERIENCE_GEM, numGreater)));
                world.func_217376_c((Entity)new ItemEntity(world, (double)m2.func_233580_cy_().func_177958_n(), (double)m2.func_233580_cy_().func_177956_o(), (double)m2.func_233580_cy_().func_177952_p(), new ItemStack((IItemProvider)ItemsRegistry.EXPERIENCE_GEM, numLesser)));
                didWorkOnce = true;
            }
            if (didWorkOnce) {
                this.setNeedsMana(true);
            }
        }
    }

    @Override
    public int getManaCost() {
        return 300;
    }

    @Override
    public String getLangName() {
        return "Disintegration";
    }

    @Override
    public String getLangDescription() {
        return "Destroys nearby monsters and converts them into Experience Gems worth twice as much experience. Monsters destroyed this way will not drop items. This ritual consumes source each time a monster is destroyed.";
    }

    @Override
    public ParticleColor getCenterColor() {
        return ParticleColor.makeRandomColor(220, 20, 20, this.rand);
    }

    @Override
    public String getID() {
        return "disintegration";
    }
}

