/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RitualAwakening
extends AbstractRitual {
    List<BlockPos> treePos = new ArrayList<BlockPos>();
    EntityType<WealdWalker> entity = null;
    BlockPos foundPos;

    public void destroyTree(World world, Set<BlockPos> set) {
        for (BlockPos p : set) {
            BlockUtil.destroyBlockSafelyWithoutSound(world, p, false);
        }
    }

    public void findTree(World world) {
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)this.getPos().func_177965_g(3).func_177970_e(3).func_177979_c(1), (BlockPos)this.getPos().func_177985_f(3).func_177964_d(3).func_177981_b(1))) {
            Set<BlockPos> blazing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.func_177230_c() == BlockRegistry.BLAZING_LOG || b.func_177230_c() == BlockRegistry.BLAZING_LEAVES);
            if (blazing.size() >= 50) {
                this.entity = ModEntities.ENTITY_BLAZING_WEALD;
                this.foundPos = p;
                this.destroyTree(world, blazing);
                return;
            }
            Set<BlockPos> flourishing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.func_177230_c() == BlockRegistry.FLOURISHING_LOG || b.func_177230_c() == BlockRegistry.FLOURISHING_LEAVES);
            if (flourishing.size() >= 50) {
                this.entity = ModEntities.ENTITY_FLOURISHING_WEALD;
                this.foundPos = p;
                this.destroyTree(world, flourishing);
                return;
            }
            Set<BlockPos> vexing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.func_177230_c() == BlockRegistry.VEXING_LOG || b.func_177230_c() == BlockRegistry.VEXING_LEAVES);
            if (vexing.size() >= 50) {
                this.entity = ModEntities.ENTITY_VEXING_WEALD;
                this.foundPos = p;
                this.destroyTree(world, vexing);
                return;
            }
            Set<BlockPos> cascading = SpellUtil.DFSBlockstates(world, p, 350, b -> b.func_177230_c() == BlockRegistry.CASCADING_LOG || b.func_177230_c() == BlockRegistry.CASCADING_LEAVE);
            if (cascading.size() < 50) continue;
            this.entity = ModEntities.ENTITY_CASCADING_WEALD;
            this.foundPos = p;
            this.destroyTree(world, cascading);
            return;
        }
    }

    @Override
    protected void tick() {
        World world = this.getWorld();
        if (world.field_72995_K) {
            BlockPos pos = this.getPos();
            for (int i = 0; i < 100; ++i) {
                Vector3d particlePos = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c(0.5, 0.0, 0.5);
                particlePos = particlePos.func_178787_e(ParticleUtil.pointInSphere().func_216372_d(5.0, 5.0, 5.0));
                world.func_195594_a(ParticleLineData.createData(this.getCenterColor()), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
            }
        }
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L) {
            this.incrementProgress();
            if (this.getProgress() > 5) {
                this.findTree(world);
                if (this.entity != null) {
                    ParticleUtil.spawnPoof((ServerWorld)world, this.foundPos);
                    WealdWalker walker = (WealdWalker)this.entity.func_200721_a(world);
                    walker.func_70107_b(this.foundPos.func_177958_n(), this.foundPos.func_177956_o(), this.foundPos.func_177952_p());
                    world.func_217376_c((Entity)walker);
                    this.setFinished();
                }
            }
        }
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(50, 200, 50);
    }

    @Override
    public void write(CompoundNBT tag) {
        super.write(tag);
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
    }

    @Override
    public String getLangName() {
        return "Awakening";
    }

    @Override
    public String getLangDescription() {
        return "Awakens nearby Archwood trees into Weald Walkers. Weald Walkers can be given a position in the world to guard against hostile mobs. They will heal over time, and turn into Weald Waddlers if they die. To create a Weald Walker, perform this ritual near the base of an Archwood Tree.";
    }

    @Override
    public String getID() {
        return "awakening";
    }
}

