/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketWarpPosition {
    private final int entityID;
    double x;
    double y;
    double z;
    float xRot;
    float yRot;

    public PacketWarpPosition(Entity entity, double x, double y, double z) {
        this.entityID = entity.func_145782_y();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketWarpPosition(int id, double x, double y, double z, float xRot, float yRot) {
        this.entityID = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xRot = xRot;
        this.yRot = yRot;
    }

    public static PacketWarpPosition decode(PacketBuffer buf) {
        return new PacketWarpPosition(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat());
    }

    public static void encode(PacketWarpPosition msg, PacketBuffer buf) {
        buf.writeInt(msg.entityID);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeFloat(msg.xRot);
        buf.writeFloat(msg.yRot);
    }

    public static class Handler {
        public static void handle(final PacketWarpPosition message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    ClientWorld world = mc.field_71441_e;
                    Entity e = world.func_73045_a(message.entityID);
                    if (e == null) {
                        return;
                    }
                    e.func_70107_b(message.x, message.y, message.z);
                    e.field_70125_A = message.xRot;
                    e.field_70177_z = message.yRot;
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

