/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WarpScroll
extends ModItem {
    public WarpScroll() {
        super(ItemsRegistry.defaultItemProperties(), "warp_scroll");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.func_130014_f_().field_72995_K) {
            String displayName;
            String string = displayName = stack.func_82837_s() ? stack.func_200301_q().getString() : "";
            if (WarpScroll.getPos(stack) != BlockPos.field_177992_a && this.getDimension(stack).equals(entity.func_130014_f_().func_234923_W_().getRegistryName().toString()) && ManaUtil.hasManaNearby(entity.func_233580_cy_(), entity.func_130014_f_(), 10, 9000) && (BlockRegistry.PORTAL_BLOCK.trySpawnPortal((IWorld)entity.func_130014_f_(), entity.func_233580_cy_(), WarpScroll.getPos(stack), this.getDimension(stack), WarpScroll.getRotationVector(stack), displayName) || BlockRegistry.PORTAL_BLOCK.trySpawnHoriztonalPortal(entity.func_130014_f_(), entity.func_233580_cy_(), WarpScroll.getPos(stack), this.getDimension(stack), WarpScroll.getRotationVector(stack), displayName)) && ManaUtil.takeManaNearbyWithParticles(entity.func_233580_cy_(), entity.func_130014_f_(), 10, 9000) != null) {
                BlockPos pos = entity.func_233580_cy_();
                ServerWorld world = (ServerWorld)entity.func_130014_f_();
                world.func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 10, (world.field_73012_v.nextDouble() - 0.5) * 2.0, -world.field_73012_v.nextDouble(), (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)0.1f);
                world.func_184133_a(null, pos, SoundEvents.field_193784_dd, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                stack.func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = WarpScroll.getPos(stack);
        if (hand == Hand.OFF_HAND) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (world.func_201670_d()) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!pos.equals((Object)BlockPos.field_177992_a)) {
            if (this.getDimension(stack) == null || !this.getDimension(stack).equals(player.func_130014_f_().func_234923_W_().getRegistryName().toString())) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.warp_scroll.wrong_dim"), Util.field_240973_b_);
                return ActionResult.func_226251_d_((Object)stack);
            }
            player.func_223102_j((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            Vector2f rotation = WarpScroll.getRotationVector(stack);
            player.field_70125_A = rotation.field_189982_i;
            player.field_70177_z = rotation.field_189983_j;
            stack.func_190918_g(1);
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (player.func_225608_bj_()) {
            boolean didAdd;
            ItemStack newWarpStack = new ItemStack((IItemProvider)ItemsRegistry.warpScroll);
            newWarpStack.func_77982_d(new CompoundNBT());
            this.setTeleportTag(newWarpStack, player.func_233580_cy_(), player.func_130014_f_().func_234923_W_().getRegistryName().toString());
            WarpScroll.setRotationVector(newWarpStack, player.func_189653_aC());
            if (stack.func_190916_E() == 1) {
                stack = newWarpStack;
                didAdd = true;
            } else {
                didAdd = player.func_191521_c(newWarpStack);
                if (didAdd) {
                    stack.func_190918_g(1);
                }
            }
            if (!didAdd) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.warp_scroll.inv_full"), Util.field_240973_b_);
                return ActionResult.func_226251_d_((Object)stack);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.warp_scroll.recorded"), Util.field_240973_b_);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void setTeleportTag(ItemStack stack, BlockPos pos, String dimension) {
        stack.func_77978_p().func_74768_a("x", pos.func_177958_n());
        stack.func_77978_p().func_74768_a("y", pos.func_177956_o());
        stack.func_77978_p().func_74768_a("z", pos.func_177952_p());
        stack.func_77978_p().func_74778_a("dim_2", dimension);
    }

    public static Vector2f getRotationVector(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        return new Vector2f(tag.func_74760_g("xRot"), tag.func_74760_g("yRot"));
    }

    public static void setRotationVector(ItemStack stack, Vector2f vector2f) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74776_a("xRot", vector2f.field_189982_i);
        tag.func_74776_a("yRot", vector2f.field_189983_j);
    }

    public static BlockPos getPos(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public String getDimension(ItemStack stack) {
        return stack.func_196082_o().func_74779_i("dim_2");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag p_77624_4_) {
        BlockPos pos = WarpScroll.getPos(stack);
        if (pos.equals((Object)BlockPos.field_177992_a)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("ars_nouveau.warp_scroll.no_location"));
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("ars_nouveau.position", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
    }
}

