/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.DiveAttackGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.FlyHelper;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.LeapGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wilden.WildenMeleeAttack;
import com.hollingsworth.arsnouveau.setup.Config;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildenStalker
extends MonsterEntity
implements IAnimatable,
IAnimationListener {
    int leapCooldown;
    public Vector3d orbitOffset = Vector3d.field_186680_a;
    public BlockPos orbitPosition = BlockPos.field_177992_a;
    public static final DataParameter<Boolean> isFlying = EntityDataManager.func_187226_a(WildenStalker.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int timeFlying;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public WildenStalker(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyHelper(this);
    }

    public WildenStalker(World worldIn) {
        this(ModEntities.WILDEN_STALKER, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new LeapGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new DiveAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WildenMeleeAttack((CreatureEntity)this, 1.3, true, Animations.ATTACK.ordinal(), () -> !this.isFlying()));
        this.field_70714_bg.func_75776_a(8, (Goal)new MeleeAttackGoal((CreatureEntity)this, (double)1.2f, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        if (((Boolean)Config.STALKER_ATTACK_ANIMALS.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.leapCooldown > 0) {
                --this.leapCooldown;
            }
            if (this.isFlying() && this.func_233570_aj_()) {
                this.setFlying(false);
            }
            this.timeFlying = this.isFlying() ? ++this.timeFlying : 0;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && entityIn instanceof LivingEntity && this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76437_t, 40, 0));
        }
        return super.func_70652_k(entityIn);
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return 0;
    }

    public int getLeapCooldown() {
        return this.leapCooldown;
    }

    public void setLeapCooldown(int leapCooldown) {
        this.leapCooldown = leapCooldown;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 8;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public void startAnimation(int arg) {
        try {
            AnimationController controller;
            if (arg == Animations.DIVE.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("flyController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("dive", Boolean.valueOf(true)));
            }
            if (arg == Animations.FLY.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("flyController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("flying", Boolean.valueOf(true)));
            }
            if (arg == Animations.ATTACK.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("groundController");
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("attack")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("attack", Boolean.valueOf(false)).addAnimation("idle"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <E extends Entity> PlayState flyPredicate(AnimationEvent event) {
        return this.isFlying() ? PlayState.CONTINUE : PlayState.STOP;
    }

    private <E extends Entity> PlayState groundPredicate(AnimationEvent e) {
        return this.isFlying() ? PlayState.STOP : PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "flyController", 1.0f, this::flyPredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "groundController", 1.0f, this::groundPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.isFlying()) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (!this.isFlying()) {
            super.func_213352_e(travelVector);
            return;
        }
        if (this.func_70090_H()) {
            this.func_213309_a(0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.8f));
        } else if (this.func_180799_ab()) {
            this.func_213309_a(0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else {
            BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            this.func_213309_a(this.field_70122_E ? 0.1f * f1 : 0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
        }
        this.func_233629_a_((LivingEntity)this, false);
    }

    public static AttributeModifierMap.MutableAttribute getModdedAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233824_g_, 0.7).func_233815_a_(Attributes.field_233823_f_, 2.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(isFlying, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(isFlying);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(isFlying, (Object)flying);
    }

    public static enum Animations {
        ATTACK,
        DIVE,
        FLY;

    }
}

