/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.DrygmyTile;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.UntamedFindItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.drygmy.CollectEssenceGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.FollowMobGoalBackoff;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.FollowPlayerGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityDrygmy
extends CreatureEntity
implements IAnimatable,
ITooltipProvider,
IDispellable {
    public static final DataParameter<Boolean> CHANNELING = EntityDataManager.func_187226_a(EntityDrygmy.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityDrygmy.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> BEING_TAMED = EntityDataManager.func_187226_a(EntityDrygmy.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HOLDING_ESSENCE = EntityDataManager.func_187226_a(EntityDrygmy.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> CHANNELING_ENTITY = EntityDataManager.func_187226_a(EntityDrygmy.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int channelCooldown;
    private boolean setBehaviors;
    public BlockPos homePos;
    public int tamingTime;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    public EntityDrygmy(EntityType<? extends CreatureEntity> p_i48575_1_, World p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        this.addGoalsAfterConstructor();
    }

    public EntityDrygmy(World world, boolean tamed) {
        super(ModEntities.ENTITY_DRYGMY, world);
        this.setTamed(tamed);
        this.addGoalsAfterConstructor();
    }

    @Nullable
    public DrygmyTile getHome() {
        if (this.homePos == null || !(this.field_70170_p.func_175625_s(this.homePos) instanceof DrygmyTile)) {
            return null;
        }
        return (DrygmyTile)this.field_70170_p.func_175625_s(this.homePos);
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.DRYGMY_CHARM);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
        }
        super.func_70645_a(source);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.channelCooldown > 0) {
            --this.channelCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 60L == 0L && this.isTamed() && this.homePos != null && !(this.field_70170_p.func_175625_s(this.homePos) instanceof DrygmyTile)) {
            this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p))), 99.0f);
            return;
        }
        if (this.field_70170_p.field_72995_K && this.isChanneling() && this.getChannelEntity() != -1) {
            Entity entity = this.field_70170_p.func_73045_a(this.getChannelEntity());
            if (entity == null || entity.field_70128_L) {
                return;
            }
            Vector3d vec = entity.field_233557_ao_;
            this.field_70170_p.func_195594_a(GlowParticleData.createData(new ParticleColor(50, 255, 20)), (double)((float)vec.field_72450_a) - Math.sin((double)ClientInfo.ticksInGame / 8.0), (double)((float)vec.field_72448_b) + Math.sin((double)ClientInfo.ticksInGame / 5.0) / 8.0 + 0.5, (double)((float)vec.field_72449_c) - Math.cos((double)ClientInfo.ticksInGame / 8.0), 0.0, 0.0, 0.0);
        }
        if (!this.isTamed() && !((Boolean)this.field_70180_af.func_187225_a(BEING_TAMED)).booleanValue() && this.field_70170_p.func_82737_E() % 40L == 0L) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_186662_g(1.0))) {
                this.func_175445_a(itementity);
            }
        }
        if (!this.isTamed() && ((Boolean)this.field_70180_af.func_187225_a(BEING_TAMED)).booleanValue()) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.field_70170_p.func_201670_d()) {
                Networking.sendToNearby(this.field_70170_p, (Entity)this, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.func_233580_cy_(), new int[0]));
            }
            if (this.tamingTime > 60 && !this.field_70170_p.field_72995_K) {
                ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.DRYGMY_SHARD, 1 + this.field_70170_p.field_73012_v.nextInt(2));
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), stack));
                this.remove(false);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_193788_dg, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    private PlayState animationPredicate(AnimationEvent event) {
        if (this.isChanneling() || ((Boolean)this.field_70180_af.func_187225_a(BEING_TAMED)).booleanValue() || this.field_70170_p.field_72995_K && PatchouliHandler.isPatchouliWorld()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("channel"));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected void addGoalsAfterConstructor() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        for (PrioritizedGoal goal : this.getGoals()) {
            this.field_70714_bg.func_75776_a(goal.func_220770_h(), goal.func_220772_j());
        }
    }

    public List<PrioritizedGoal> getGoals() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHANNELING, (Object)false);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(HOLDING_ESSENCE, (Object)false);
        this.field_70180_af.func_187214_a(CHANNELING_ENTITY, (Object)-1);
        this.field_70180_af.func_187214_a(BEING_TAMED, (Object)false);
    }

    public boolean holdingEssence() {
        return (Boolean)this.field_70180_af.func_187225_a(HOLDING_ESSENCE);
    }

    public void setHoldingEssence(boolean holdingEssence) {
        this.field_70180_af.func_187227_b(HOLDING_ESSENCE, (Object)holdingEssence);
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
    }

    public boolean isChanneling() {
        return (Boolean)this.field_70180_af.func_187225_a(CHANNELING);
    }

    public void setChanneling(boolean channeling) {
        this.field_70180_af.func_187227_b(CHANNELING, (Object)channeling);
    }

    public int getChannelEntity() {
        return (Integer)this.field_70180_af.func_187225_a(CHANNELING_ENTITY);
    }

    public void setChannelingEntity(int entityID) {
        this.field_70180_af.func_187227_b(CHANNELING_ENTITY, (Object)entityID);
    }

    protected void func_184651_r() {
    }

    public List<PrioritizedGoal> getTamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new LookRandomlyGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(2, (Goal)new CollectEssenceGoal(this)));
        list.add(new PrioritizedGoal(0, (Goal)new SwimGoal((MobEntity)this)));
        return list;
    }

    public List<PrioritizedGoal> getUntamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new FollowMobGoalBackoff((MobEntity)this, 1.0, 3.0f, 7.0f, 0.5f)));
        list.add(new PrioritizedGoal(5, (Goal)new FollowPlayerGoal((MobEntity)this, 1.0, 3.0f, 7.0f)));
        list.add(new PrioritizedGoal(2, (Goal)new LookRandomlyGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0)));
        list.add(new PrioritizedGoal(0, (Goal)new SwimGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(1, (Goal)new UntamedFindItemGoal((MobEntity)this, () -> !this.isTamed() && (Boolean)this.field_70180_af.func_187225_a(BEING_TAMED) == false, itemEntity -> !itemEntity.func_174874_s() && itemEntity.func_70089_S() && itemEntity.func_92059_d().func_77973_b() == ItemsRegistry.WILDEN_HORN)));
        return list;
    }

    @Override
    public List<String> getTooltip() {
        return null;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "walkController", 20.0f, this::animationPredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "idleController", 20.0f, this::idlePredicate));
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        if (!this.isTamed() && !((Boolean)this.field_70180_af.func_187225_a(BEING_TAMED)).booleanValue() && itemEntity.func_92059_d().func_77973_b() == ItemsRegistry.WILDEN_HORN) {
            this.field_70180_af.func_187227_b(BEING_TAMED, (Object)true);
            itemEntity.func_92059_d().func_190918_g(1);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, this.func_184176_by(), 1.0f, 1.0f);
        }
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.field_70128_L) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.DRYGMY_CHARM);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_233580_cy_());
            this.func_70106_y();
        }
        return this.isTamed();
    }

    private PlayState idlePredicate(AnimationEvent event) {
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        NBTUtil.storeBlockPos(tag, "home", this.homePos);
        tag.func_74757_a("tamed", ((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue());
        tag.func_74768_a("cooldown", this.channelCooldown);
        tag.func_74768_a("taming", this.tamingTime);
        tag.func_74757_a("beingTamed", ((Boolean)this.field_70180_af.func_187225_a(BEING_TAMED)).booleanValue());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (NBTUtil.hasBlockPos(tag, "home")) {
            this.homePos = NBTUtil.getBlockPos(tag, "home");
        }
        this.setTamed(tag.func_74767_n("tamed"));
        if (!this.setBehaviors) {
            this.tryResetGoals();
            this.setBehaviors = true;
        }
        this.channelCooldown = tag.func_74762_e("cooldown");
        this.tamingTime = tag.func_74762_e("taming");
        this.field_70180_af.func_187227_b(BEING_TAMED, (Object)tag.func_74767_n("beingTamed"));
    }

    public void tryResetGoals() {
        this.field_70714_bg.field_220892_d = new LinkedHashSet();
        this.addGoalsAfterConstructor();
    }
}

