/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRedstone;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class TimerSpellTurretTile
extends BasicSpellTurretTile
implements ITickableTileEntity,
IWandable {
    private int ticksPerSignal = 20;
    public boolean isLocked;
    public boolean isOff;

    public TimerSpellTurretTile(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public TimerSpellTurretTile() {
        super(BlockRegistry.TIMER_SPELL_TURRET_TILE);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticksPerSignal > 0 && !this.isOff & this.field_145850_b.func_82737_E() % (long)this.ticksPerSignal == 0L) {
            this.func_195044_w().func_227033_a_((ServerWorld)this.field_145850_b, this.func_174877_v(), this.func_145831_w().field_73012_v);
        }
    }

    @Override
    public int getManaCost() {
        int cost = super.getManaCost();
        cost -= this.spell.getInstanceCount(MethodTouch.INSTANCE) * MethodTouch.INSTANCE.getConfigCost();
        cost -= this.spell.getInstanceCount(EffectRedstone.INSTANCE) * EffectRedstone.INSTANCE.getConfigCost();
        return Math.max(0, cost -= this.spell.getInstanceCount(MethodProjectile.INSTANCE) * MethodProjectile.INSTANCE.getConfigCost());
    }

    @Override
    public void registerControllers(AnimationData data) {
        super.registerControllers(data);
        data.addAnimationController(new AnimationController((IAnimatable)this, "spinController", 0.0f, this::spinPredicate));
    }

    public PlayState spinPredicate(AnimationEvent event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("key_rotation", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    @Override
    public void onWanded(PlayerEntity playerEntity) {
        this.isLocked = !this.isLocked;
        this.update();
    }

    public void addTime(int ticks) {
        this.ticksPerSignal += ticks;
        this.ticksPerSignal = Math.max(0, this.ticksPerSignal);
        this.update();
    }

    @Override
    public List<String> getTooltip() {
        List<String> tooltip = super.getTooltip();
        if (this.ticksPerSignal <= 0 && !this.isOff) {
            tooltip.add(new TranslationTextComponent("ars_nouveau.tooltip.turned_off").getString());
        } else {
            tooltip.add(new TranslationTextComponent("ars_nouveau.seconds", new Object[]{this.ticksPerSignal / 20}).getString());
        }
        if (this.isOff) {
            tooltip.add(new TranslationTextComponent("ars_nouveau.tooltip.turned_off").getString());
        }
        if (this.isLocked) {
            tooltip.add(new TranslationTextComponent("ars_nouveau.locked").getString());
        }
        return tooltip;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.isLocked = tag.func_74767_n("locked");
        this.ticksPerSignal = tag.func_74762_e("time");
        this.isOff = tag.func_74767_n("off");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74757_a("locked", this.isLocked);
        tag.func_74768_a("time", this.ticksPerSignal);
        tag.func_74757_a("off", this.isOff);
        return super.func_189515_b(tag);
    }
}

