/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.mana.IManaTile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.ArcaneRelaySplitterTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;

public class RelayWarpTile
extends ArcaneRelaySplitterTile {
    public RelayWarpTile(TileEntityType<?> type) {
        super(type);
    }

    public RelayWarpTile() {
        super(BlockRegistry.RELAY_WARP_TILE);
    }

    @Override
    public void createParticles(BlockPos from, BlockPos to) {
        if (this.field_145850_b.func_175625_s(to) instanceof RelayWarpTile) {
            ParticleUtil.spawnTouchPacket(this.field_145850_b, this.func_174877_v(), new ParticleColor.IntWrapper(220, 50, 220));
            ParticleUtil.spawnTouchPacket(this.field_145850_b, to, new ParticleColor.IntWrapper(220, 50, 220));
        } else {
            super.createParticles(from, to);
        }
    }

    @Override
    public int transferMana(IManaTile from, IManaTile to, int fromTransferRate) {
        if (to instanceof RelayWarpTile) {
            RelayWarpTile toWarp = (RelayWarpTile)to;
            double adjustedDist = BlockUtil.distanceFrom(toWarp.field_174879_c, this.field_174879_c) - 30.0;
            double probLoss = adjustedDist / 100.0;
            if (adjustedDist > 0.0 && (double)this.field_145850_b.func_201674_k().nextFloat() < probLoss) {
                int transferRate = this.getTransferRate(from, to, fromTransferRate);
                if (transferRate == 0) {
                    return 0;
                }
                from.removeMana(transferRate);
                int lossyTransfer = Math.max(1, (int)((double)transferRate * 0.7));
                to.addMana(lossyTransfer);
                return lossyTransfer;
            }
        }
        return super.transferMana(from, to, fromTransferRate);
    }

    @Override
    public boolean closeEnough(BlockPos pos) {
        return this.field_145850_b.func_175625_s(pos) instanceof RelayWarpTile || super.closeEnough(pos);
    }
}

