/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.mixin.ExpInvokerMixin;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.Config;
import com.hollingsworth.arsnouveau.setup.EntityTags;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class DrygmyTile
extends SummoningTile
implements ITooltipProvider {
    public int progress;
    public int bonus;
    public boolean needsMana;
    private List<LivingEntity> nearbyEntities;

    public DrygmyTile() {
        super(BlockRegistry.DRYGMY_TILE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            for (int i = 0; i < this.progress / 2; ++i) {
                this.field_145850_b.func_195594_a(GlowParticleData.createData(new ParticleColor(50, 255, 20)), (double)this.func_174877_v().func_177958_n() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), (double)(this.func_174877_v().func_177956_o() + 1) + ParticleUtil.inRange(-0.1, 0.1), (double)this.func_174877_v().func_177952_p() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), 0.0, 0.0, 0.0);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 100L == 0L) {
            this.refreshEntitiesAndBonus();
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 80L == 0L && this.needsMana && ManaUtil.takeManaNearbyWithParticles(this.field_174879_c, this.field_145850_b, 7, (Integer)Config.DRYGMY_MANA_COST.get()) != null) {
            this.needsMana = false;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        if (!(this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 100L != 0L || this.needsMana || this.progress < this.getMaxProgress() || this.getNearbyEntities().isEmpty())) {
            this.generateItems();
        }
    }

    public List<LivingEntity> getNearbyEntities() {
        if (this.nearbyEntities == null) {
            this.refreshEntitiesAndBonus();
        }
        return this.nearbyEntities;
    }

    @Nullable
    public LivingEntity getRandomEntity() {
        if (this.getNearbyEntities().isEmpty()) {
            return null;
        }
        return this.getNearbyEntities().get(new Random().nextInt(this.getNearbyEntities().size()));
    }

    public void giveProgress() {
        if (this.progress < this.getMaxProgress()) {
            ++this.progress;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public int getMaxProgress() {
        return (Integer)Config.DRYGMY_MAX_PROGRESS.get();
    }

    @Override
    public void convertedEffect() {
        super.convertedEffect();
        if (this.tickCounter >= 120 && !this.field_145850_b.field_72995_K) {
            this.converted = true;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityDrygmy entityDrygmy = new EntityDrygmy(this.field_145850_b, true);
            entityDrygmy.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
            entityDrygmy.homePos = new BlockPos((Vector3i)this.func_174877_v());
            this.field_145850_b.func_217376_c((Entity)entityDrygmy);
            ParticleUtil.spawnPoof((ServerWorld)this.field_145850_b, this.field_174879_c.func_177984_a());
            this.tickCounter = 0;
            return;
        }
        if (this.tickCounter % 10 == 0 && !this.field_145850_b.field_72995_K) {
            Random r = this.field_145850_b.field_73012_v;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.field_145850_b, this.field_174879_c.func_177982_a(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.field_174879_c, r.nextInt(255), r.nextInt(255), r.nextInt(255));
            this.field_145850_b.func_217376_c((Entity)proj1);
        }
    }

    public void refreshEntitiesAndBonus() {
        this.nearbyEntities = this.field_145850_b.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_174877_v().func_177964_d(10).func_177985_f(10).func_177979_c(6), this.func_174877_v().func_177970_e(10).func_177965_g(10).func_177981_b(6)));
        this.nearbyEntities = this.nearbyEntities.stream().filter(l -> !(l instanceof EntityDrygmy) && !(l instanceof PlayerEntity)).collect(Collectors.toList());
        Set uniqueEntities = this.nearbyEntities.stream().map(l -> EntityType.func_200718_a((EntityType)l.func_200600_R())).collect(Collectors.toSet());
        this.bonus = uniqueEntities.size() * (Integer)Config.DRYGMY_UNIQUE_BONUS.get() + Math.min((Integer)Config.DRYGMY_QUANTITY_CAP.get(), this.nearbyEntities.size());
    }

    public void generateItems() {
        ArrayList stacks = new ArrayList();
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerWorld)this.field_145850_b);
        DamageSource damageSource = DamageSource.func_76365_a((PlayerEntity)fakePlayer);
        int numberItems = (Integer)Config.DRYGMY_BASE_ITEM.get() + this.bonus;
        int exp = 0;
        for (LivingEntity entity : this.getNearbyEntities()) {
            if (entity.func_200600_R().func_220341_a(EntityTags.DRYGMY_BLACKLIST)) continue;
            LootTable loottable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(entity.func_213346_cF());
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.field_145850_b.func_201674_k()).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_237457_g_, (Object)entity.func_213303_ch()).func_216015_a(LootParameters.field_216283_c, (Object)damageSource).func_216021_b(LootParameters.field_216284_d, (Object)fakePlayer.getEntity()).func_216021_b(LootParameters.field_216285_e, (Object)damageSource.func_76364_f());
            lootcontext$builder = lootcontext$builder.func_216015_a(LootParameters.field_216282_b, (Object)fakePlayer).func_186469_a(fakePlayer.func_184817_da());
            LootContext ctx = lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d);
            stacks.addAll(loottable.func_216113_a(ctx));
            int oldExp = 0;
            if (entity instanceof MobEntity) {
                oldExp = ((MobEntity)entity).field_70728_aV;
            }
            exp += ((ExpInvokerMixin)entity).an_getExperienceReward((PlayerEntity)fakePlayer);
            if (!(entity instanceof MobEntity)) continue;
            ((MobEntity)entity).field_70728_aV = oldExp;
        }
        int itemsPicked = 0;
        if (stacks.size() > 0) {
            for (int i = 0; i < numberItems; ++i) {
                ItemStack stack = ((ItemStack)stacks.get(this.field_145850_b.field_73012_v.nextInt(stacks.size()))).func_77946_l();
                BlockUtil.insertItemAdjacent(this.field_145850_b, this.field_174879_c, stack);
                if ((itemsPicked += stack.func_190916_E()) >= numberItems) break;
            }
        }
        if ((exp = (int)((double)exp * 0.25)) > 3) {
            int numLesser;
            int numGreater;
            if ((exp -= (numGreater = exp / 12) * 12) - (numLesser = exp / 3) * 3 > 0) {
                ++numLesser;
            }
            if (numGreater > 0) {
                BlockUtil.insertItemAdjacent(this.field_145850_b, this.field_174879_c, new ItemStack((IItemProvider)ItemsRegistry.GREATER_EXPERIENCE_GEM, numGreater));
            }
            if (numLesser > 0) {
                BlockUtil.insertItemAdjacent(this.field_145850_b, this.field_174879_c, new ItemStack((IItemProvider)ItemsRegistry.EXPERIENCE_GEM, numLesser));
            }
        }
        this.progress = 0;
        this.needsMana = true;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.progress = compound.func_74762_e("progress");
        this.bonus = compound.func_74762_e("bonus");
        this.needsMana = compound.func_74767_n("needsMana");
        super.func_230337_a_(state, compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("bonus", this.bonus);
        compound.func_74757_a("needsMana", this.needsMana);
        return super.func_189515_b(compound);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.needsMana) {
            list.add(new TranslationTextComponent("ars_nouveau.wixie.need_mana").getString());
        }
        return list;
    }
}

