/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AlchemicalSourcelinkTile
extends SourcelinkTile {
    public AlchemicalSourcelinkTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public AlchemicalSourcelinkTile() {
        super(BlockRegistry.ALCHEMICAL_TILE);
    }

    @Override
    public int getMaxMana() {
        return 20000;
    }

    @Override
    public int getTransferRate() {
        return 10000;
    }

    @Override
    public void func_73660_a() {
        BlockPos potionPos;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L && (potionPos = AlchemicalSourcelinkTile.findNearbyPotion(this.field_145850_b, this.field_174879_c)) != null) {
            PotionJarTile tile = (PotionJarTile)this.field_145850_b.func_175625_s(potionPos);
            int mana = 75;
            HashSet<Effect> effectTypes = new HashSet<Effect>();
            for (EffectInstance e : tile.getFullEffects()) {
                mana += e.func_76459_b() / 50;
                mana += e.func_76458_c() * 250;
                mana += 150;
                effectTypes.add(e.func_188419_a());
            }
            if (effectTypes.size() > 1) {
                mana = (int)((double)mana * (1.5 * (double)(effectTypes.size() - 1)));
            }
            this.addMana(mana);
            tile.addAmount(-100);
        }
    }

    @Nullable
    public static BlockPos findNearbyPotion(World level, BlockPos worldPosition) {
        for (BlockPos p : BlockPos.func_239583_a_((BlockPos)worldPosition.func_177979_c(1), (int)1, (int)1, (int)1)) {
            PotionJarTile tile;
            if (!(level.func_175625_s(p) instanceof PotionJarTile) || (tile = (PotionJarTile)level.func_175625_s(p)).getCurrentFill() < 100) continue;
            return p;
        }
        return null;
    }
}

