/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ScribesBlock
extends ModBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    protected static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.func_208617_a((double)16.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.func_208617_a((double)16.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_NORTH_EAST});
    protected static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_SOUTH_EAST});
    protected static final VoxelShape WEST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape EAST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public ScribesBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(2.0f, 3.0f).func_226896_b_(), "scribes_table");
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)BedPart.FOOT));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public PushReaction func_149656_h(BlockState p_149656_1_) {
        return PushReaction.BLOCK;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (handIn != Hand.MAIN_HAND || !(world.func_175625_s(pos) instanceof ScribesTile)) {
            return ActionResultType.PASS;
        }
        ScribesTile tile = (ScribesTile)world.func_175625_s(pos);
        if (state.func_177229_b(PART) != BedPart.HEAD) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(ScribesBlock.getConnectedDirection(state)));
            ScribesTile scribesTile = tile = tileEntity instanceof ScribesTile ? (ScribesTile)tileEntity : null;
            if (tile == null) {
                return ActionResultType.PASS;
            }
        }
        if (!player.func_225608_bj_()) {
            ItemEntity item;
            if (tile.stack != null && player.func_184586_b(handIn).func_190926_b()) {
                item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), tile.stack);
                world.func_217376_c((Entity)item);
                tile.stack = null;
            } else if (!player.field_71071_by.func_70448_g().func_190926_b()) {
                if (tile.stack != null) {
                    item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), tile.stack);
                    world.func_217376_c((Entity)item);
                }
                tile.stack = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            BlockState updateState = world.func_180495_p(tile.func_174877_v());
            world.func_184138_a(tile.func_174877_v(), updateState, updateState, 2);
        }
        if (player.func_225608_bj_()) {
            ItemStack stack = tile.stack;
            if (stack == null || stack.func_190926_b()) {
                return ActionResultType.SUCCESS;
            }
            if (stack.func_77973_b() instanceof IScribeable) {
                ((IScribeable)stack.func_77973_b()).onScribe(world, pos, player, handIn, stack);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (worldIn.func_175625_s(pos) instanceof ScribesTile && ((ScribesTile)worldIn.func_175625_s((BlockPos)pos)).stack != null) {
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((ScribesTile)worldIn.func_175625_s((BlockPos)pos)).stack));
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (!world.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((Property)FACING));
            world.func_180501_a(blockpos, (BlockState)state.func_206870_a(PART, (Comparable)BedPart.HEAD), 3);
            world.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)world, pos, 3);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        Direction direction = p_196258_1_.func_195992_f();
        BlockPos blockpos = p_196258_1_.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        return p_196258_1_.func_195991_k().func_180495_p(blockpos1).func_196953_a(p_196258_1_) ? (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction) : null;
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entity) {
        Vector3d vec = entity.func_213303_ch();
        Direction direction = Direction.func_176737_a((float)((float)(vec.field_72450_a - (double)clickedBlock.func_177958_n())), (float)((float)(vec.field_72448_b - (double)clickedBlock.func_177956_o())), (float)((float)(vec.field_72449_c - (double)clickedBlock.func_177952_p())));
        if (direction == Direction.UP || direction == Direction.DOWN) {
            direction = Direction.NORTH;
        }
        return direction;
    }

    public BlockState tearDown(BlockState state, Direction direction, BlockState state2, IWorld world, BlockPos pos, BlockPos pos2) {
        TileEntity entity;
        if (!world.func_201670_d() && (entity = world.func_175625_s(pos)) instanceof ScribesTile && ((ScribesTile)entity).stack != null) {
            world.func_217376_c((Entity)new ItemEntity((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((ScribesTile)entity).stack));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState state2, IWorld world, BlockPos pos, BlockPos pos2) {
        if (direction == ScribesBlock.getNeighbourDirection((BedPart)state.func_177229_b(PART), (Direction)state.func_177229_b((Property)FACING))) {
            return state2.func_203425_a((Block)this) && state2.func_177229_b(PART) != state.func_177229_b(PART) ? state : this.tearDown(state, direction, state2, world, pos, pos2);
        }
        return super.func_196271_a(state, direction, state2, world, pos, pos2);
    }

    private static Direction getNeighbourDirection(BedPart p_208070_0_, Direction p_208070_1_) {
        return p_208070_0_ == BedPart.FOOT ? p_208070_1_ : p_208070_1_.func_176734_d();
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!(event.getWorld().func_175625_s(event.getPos()) instanceof ScribesTile)) {
            return;
        }
        World world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() instanceof ScribesBlock) {
            BlockRegistry.SCRIBES_BLOCK.func_225533_a_(world.func_180495_p(pos), world, pos, event.getPlayer(), event.getHand(), null);
            event.setCanceled(true);
        }
    }

    public static Direction getConnectedDirection(BlockState p_226862_0_) {
        Direction direction = (Direction)p_226862_0_.func_177229_b((Property)FACING);
        return p_226862_0_.func_177229_b(PART) == BedPart.HEAD ? direction.func_176734_d() : direction;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        Direction direction = ScribesBlock.getConnectedDirection(p_220053_1_).func_176734_d();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, PART});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ScribesTile();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

