/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.items.RunicChalk;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RuneBlock
extends ModBlock {
    public static VoxelShape shape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public RuneBlock() {
        super(RuneBlock.defaultProperties().func_200942_a().func_226896_b_().func_200948_a(0.0f, 0.0f), "rune");
    }

    public RuneBlock(AbstractBlock.Properties properties, String registryName) {
        super(properties, registryName);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        if (!worldIn.field_72995_K && stack.func_77973_b() instanceof RunicChalk && ((RuneTile)worldIn.func_175625_s((BlockPos)pos)).isTemporary) {
            ((RuneTile)worldIn.func_175625_s((BlockPos)pos)).isTemporary = false;
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.rune.setperm"));
            return ActionResultType.SUCCESS;
        }
        if (!(stack.func_77973_b() instanceof SpellParchment) || worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        Spell spell = SpellParchment.getSpell(stack);
        if (spell.isEmpty()) {
            return ActionResultType.SUCCESS;
        }
        if (!(spell.recipe.get(0) instanceof MethodTouch)) {
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.rune.touch"));
            return ActionResultType.SUCCESS;
        }
        ((RuneTile)worldIn.func_175625_s(pos)).setSpell(spell);
        PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.spell_set"));
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (worldIn.func_175625_s(pos) instanceof RuneTile && ((RuneTile)worldIn.func_175625_s((BlockPos)pos)).touchedEntity != null) {
            RuneTile rune = (RuneTile)worldIn.func_175625_s(pos);
            rune.castSpell(rune.touchedEntity);
            rune.touchedEntity = null;
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (worldIn.func_175625_s(pos) instanceof RuneTile) {
            ((RuneTile)worldIn.func_175625_s((BlockPos)pos)).touchedEntity = entityIn;
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RuneTile();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }
}

