/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RitualTile;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RitualBlock
extends ModBlock {
    public static final Property<Boolean> LIT = BooleanProperty.func_177716_a((String)"lit");

    public RitualBlock(String registryName) {
        super(RitualBlock.defaultProperties().func_226896_b_().func_235838_a_(b -> (Boolean)b.func_177229_b(LIT) != false ? 15 : 0), registryName);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!(worldIn.func_175625_s(pos) instanceof RitualTile) || handIn != Hand.MAIN_HAND || !player.func_184614_ca().func_190926_b()) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        RitualTile tile = (RitualTile)worldIn.func_175625_s(pos);
        if (tile.ritual != null && !tile.isRitualDone()) {
            tile.startRitual();
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public PushReaction func_149656_h(BlockState p_149656_1_) {
        return PushReaction.BLOCK;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.func_201670_d() && world.func_175625_s(pos) instanceof RitualTile) {
            ((RitualTile)world.func_175625_s((BlockPos)pos)).isOff = world.func_175640_z(pos);
            BlockUtil.safelyUpdateState(world, pos);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (worldIn.func_175625_s(pos) instanceof RitualTile) {
            RitualTile tile = (RitualTile)worldIn.func_175625_s(pos);
            if (tile.ritual != null && !tile.ritual.isRunning() && !tile.ritual.isDone()) {
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getRitualItemMap().get(tile.ritual.getID()))));
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a(LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RitualTile();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

