/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class ArchwoodChestRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private final ModelRenderer lid;
    private final ModelRenderer bottom;
    private final ModelRenderer lock;
    private final ModelRenderer doubleLeftLid;
    private final ModelRenderer doubleLeftBottom;
    private final ModelRenderer doubleLeftLock;
    private final ModelRenderer doubleRightLid;
    private final ModelRenderer doubleRightBottom;
    private final ModelRenderer doubleRightLock;
    private boolean xmasTextures;
    public static Block invBlock = null;

    public ArchwoodChestRenderer(TileEntityRendererDispatcher p_i226008_1_) {
        super(p_i226008_1_);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        this.bottom = new ModelRenderer(64, 64, 0, 19);
        this.bottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.lid = new ModelRenderer(64, 64, 0, 0);
        this.lid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.lid.field_78797_d = 9.0f;
        this.lid.field_78798_e = 1.0f;
        this.lock = new ModelRenderer(64, 64, 0, 0);
        this.lock.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.lock.field_78797_d = 8.0f;
        this.doubleLeftBottom = new ModelRenderer(64, 64, 0, 19);
        this.doubleLeftBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.doubleLeftLid = new ModelRenderer(64, 64, 0, 0);
        this.doubleLeftLid.func_228301_a_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.doubleLeftLid.field_78797_d = 9.0f;
        this.doubleLeftLid.field_78798_e = 1.0f;
        this.doubleLeftLock = new ModelRenderer(64, 64, 0, 0);
        this.doubleLeftLock.func_228301_a_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.doubleLeftLock.field_78797_d = 8.0f;
        this.doubleRightBottom = new ModelRenderer(64, 64, 0, 19);
        this.doubleRightBottom.func_228301_a_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.doubleRightLid = new ModelRenderer(64, 64, 0, 0);
        this.doubleRightLid.func_228301_a_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.doubleRightLid.field_78797_d = 9.0f;
        this.doubleRightLid.field_78798_e = 1.0f;
        this.doubleRightLock = new ModelRenderer(64, 64, 0, 0);
        this.doubleRightLock.func_228301_a_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.doubleRightLock.field_78797_d = 8.0f;
    }

    public void func_225616_a_(T tileEntity, float p_225616_2_, MatrixStack ms, IRenderTypeBuffer buffer, int p_225616_5_, int p_225616_6_) {
        World world = tileEntity.func_145831_w();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntity.func_195044_w() : (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.func_235901_b_((Property)ChestBlock.field_196314_b) ? (ChestType)blockstate.func_177229_b((Property)ChestBlock.field_196314_b) : ChestType.SINGLE;
        Block block = blockstate.func_177230_c();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            ms.func_227860_a_();
            float f = ((Direction)blockstate.func_177229_b((Property)ChestBlock.field_176459_a)).func_185119_l();
            ms.func_227861_a_(0.5, 0.5, 0.5);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            ms.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper icallbackwrapper = flag ? abstractchestblock.func_225536_a_(blockstate, world, tileEntity.func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.apply(ChestBlock.func_226917_a_((IChestLid)((IChestLid)tileEntity)))).get(p_225616_2_);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)icallbackwrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(p_225616_5_);
            RenderMaterial rendermaterial = this.getMaterial(tileEntity, chesttype);
            IVertexBuilder ivertexbuilder = rendermaterial.func_229311_a_(buffer, RenderType::func_228638_b_);
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(ms, ivertexbuilder, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, p_225616_6_);
                } else {
                    this.render(ms, ivertexbuilder, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, p_225616_6_);
                }
            } else {
                this.render(ms, ivertexbuilder, this.lid, this.lock, this.bottom, f1, i, p_225616_6_);
            }
            ms.func_227865_b_();
        }
    }

    private void render(MatrixStack p_228871_1_, IVertexBuilder p_228871_2_, ModelRenderer p_228871_3_, ModelRenderer p_228871_4_, ModelRenderer p_228871_5_, float p_228871_6_, int p_228871_7_, int p_228871_8_) {
        p_228871_4_.field_78795_f = p_228871_3_.field_78795_f = -(p_228871_6_ * 1.5707964f);
        p_228871_3_.func_228308_a_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
        p_228871_4_.func_228308_a_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
        p_228871_5_.func_228308_a_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
    }

    protected RenderMaterial getMaterial(T tileEntity, ChestType chestType) {
        switch (chestType) {
            case LEFT: {
                return new RenderMaterial(Atlases.field_228747_f_, new ResourceLocation("ars_nouveau", "entity/archwood_chest_left"));
            }
            case RIGHT: {
                return new RenderMaterial(Atlases.field_228747_f_, new ResourceLocation("ars_nouveau", "entity/archwood_chest_right"));
            }
        }
        return new RenderMaterial(Atlases.field_228747_f_, new ResourceLocation("ars_nouveau", "entity/archwood_chest"));
    }

    public static ItemStackTileEntityRenderer getRenderer() {
        return new ItemStackTileEntityRenderer(){
            private TileEntity tile = null;

            public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrix, IRenderTypeBuffer buffer, int x, int y) {
                if (this.tile == null) {
                    this.tile = BlockRegistry.ARCHWOOD_CHEST_TILE.func_200968_a();
                }
                if (this.tile == null) {
                    return;
                }
                TileEntityRendererDispatcher.field_147556_a.func_228852_a_(this.tile, matrix, buffer, x, y);
            }
        };
    }
}

