/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleSparkleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.entity.SylphModel;
import com.hollingsworth.arsnouveau.common.entity.EntitySylph;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class SylphRenderer
extends GeoEntityRenderer {
    public SylphRenderer(EntityRendererManager manager) {
        super(manager, (AnimatedGeoModel)new SylphModel());
    }

    public void render(LivingEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        World world = entityIn.func_130014_f_();
        Random rand = ParticleUtil.r;
        Vector3d particlePos = entityIn.func_213303_ch();
        IBone sylph = ((SylphModel)this.getGeoModelProvider()).getBone("sylph");
        IBone propellers = ((SylphModel)this.getGeoModelProvider()).getBone("propellers");
        float offsetY = sylph.getPositionY() / 9.0f;
        float roteAngle = propellers.getRotationY() / 4.0f;
        if (rand.nextInt(5) == 0) {
            for (int i = 0; i < 5; ++i) {
                world.func_195594_a(ParticleSparkleData.createData(new ParticleColor(52, 255, 36), 0.05f, 60), particlePos.func_82615_a() + Math.cos(roteAngle) / 2.0, particlePos.func_82617_b() + 0.5 + (double)offsetY, particlePos.func_82616_c() + Math.sin(roteAngle) / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public ResourceLocation getTextureLocation(LivingEntity entity) {
        if (entity instanceof EntitySylph) {
            return new ResourceLocation("ars_nouveau", "textures/entity/sylph_" + (((EntitySylph)entity).getColor().isEmpty() ? "summer" : ((EntitySylph)entity).getColor()) + ".png");
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/sylph_summer.png");
    }

    public RenderType getRenderType(Object animatable, float partialTicks, MatrixStack stack, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228640_c_((ResourceLocation)textureLocation);
    }
}

