/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.client.renderer.entity.CarbuncleModel;
import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.util.RenderUtils;

public class CarbuncleRenderer
extends GeoEntityRenderer<EntityCarbuncle> {
    private static final ResourceLocation ORANGE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");
    private static final ResourceLocation PURPLE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_purple.png");
    private static final ResourceLocation GREEN = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_green.png");
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");
    EntityCarbuncle carbuncle;
    IRenderTypeBuffer buffer;
    ResourceLocation text;

    public CarbuncleRenderer(EntityRendererManager manager) {
        super(manager, (AnimatedGeoModel)new CarbuncleModel());
    }

    protected void applyRotations(EntityCarbuncle entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public void renderEarly(EntityCarbuncle animatable, MatrixStack stackIn, float ticks, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.carbuncle = animatable;
        this.buffer = renderTypeBuffer;
        this.text = this.getTextureLocation(animatable);
        super.renderEarly((LivingEntity)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    public void render(EntityCarbuncle entity, float entityYaw, float p_225623_3_, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int p_225623_6_) {
        super.render((LivingEntity)entity, entityYaw, p_225623_3_, matrixStack, iRenderTypeBuffer, p_225623_6_);
    }

    public void renderRecursively(GeoBone bone, MatrixStack stack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("item")) {
            stack.func_227860_a_();
            RenderUtils.moveToPivot((GeoBone)bone, (MatrixStack)stack);
            stack.func_227861_a_(0.0, -0.1, 0.0);
            stack.func_227862_a_(0.75f, 0.75f, 0.75f);
            ItemStack itemstack = this.carbuncle.getHeldStack();
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemstack, ItemCameraTransforms.TransformType.GROUND, packedLightIn, OverlayTexture.field_229196_a_, stack, this.buffer);
            stack.func_227865_b_();
            bufferIn = this.buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.text));
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public ResourceLocation getColor(EntityCarbuncle e) {
        String color = ((String)e.func_184212_Q().func_187225_a(EntityCarbuncle.COLOR)).toLowerCase();
        if (color.isEmpty()) {
            return ORANGE;
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_" + color + ".png");
    }

    public ResourceLocation getTextureLocation(EntityCarbuncle entity) {
        return entity.isTamed() ? this.getColor(entity) : WILD_TEXTURE;
    }

    public RenderType getRenderType(EntityCarbuncle animatable, float partialTicks, MatrixStack stack, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228640_c_((ResourceLocation)textureLocation);
    }
}

