/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.patchouli;

import com.hollingsworth.arsnouveau.api.recipe.GlyphPressRecipe;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class GlyphPressProcessor
implements IComponentProcessor {
    GlyphPressRecipe recipe;

    public void setup(IVariableProvider variables) {
        RecipeManager manager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        String recipeID = variables.get("recipe").asString();
        this.recipe = manager.func_215367_a(new ResourceLocation(recipeID)).orElse(null);
    }

    public IVariable process(String s) {
        if (this.recipe == null) {
            return null;
        }
        if (s.equals("clay_type")) {
            return IVariable.from((Object)this.recipe.getClay());
        }
        if (s.equals("reagent")) {
            return IVariable.from((Object)this.recipe.reagent);
        }
        if (s.equals("tier")) {
            return IVariable.wrap((String)new TranslationTextComponent("ars_nouveau.spell_tier." + this.recipe.tier.toString().toLowerCase()).getString());
        }
        if (s.equals("schools")) {
            AbstractSpellPart part = ((Glyph)this.recipe.output.func_77973_b()).spellPart;
            StringBuilder str = new StringBuilder("");
            for (SpellSchool spellSchool : part.getSchools()) {
                str.append(spellSchool.getTextComponent().getString()).append(",");
            }
            if (!part.getSchools().isEmpty()) {
                str = new StringBuilder(str.substring(0, str.length() - 1));
            }
            return IVariable.wrap((String)str.toString());
        }
        if (s.equals("mana_cost")) {
            if (this.recipe.output.func_77973_b() instanceof Glyph) {
                int cost = ((Glyph)this.recipe.output.func_77973_b()).spellPart.getManaCost();
                String costLang = "";
                if (cost == 0) {
                    costLang = new TranslationTextComponent("ars_nouveau.mana_cost.none").getString();
                }
                if (cost < 20) {
                    costLang = new TranslationTextComponent("ars_nouveau.mana_cost.low").getString();
                }
                if (cost < 50) {
                    costLang = new TranslationTextComponent("ars_nouveau.mana_cost.medium").getString();
                }
                if (cost >= 50) {
                    costLang = new TranslationTextComponent("ars_nouveau.mana_cost.high").getString();
                }
                return IVariable.wrap((String)costLang);
            }
            return IVariable.wrap((String)"");
        }
        return null;
    }
}

