/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockUtil {
    public static BlockPos toPos(Vector3d vec) {
        return new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static boolean isTreeBlock(Block block) {
        return block.func_203417_a((ITag)BlockTags.field_206952_E) || block.func_203417_a((ITag)BlockTags.field_200031_h);
    }

    public static boolean containsStateInRadius(World world, BlockPos start, int radius, Class clazz) {
        for (double x = (double)(start.func_177958_n() - radius); x <= (double)(start.func_177958_n() + radius); x += 1.0) {
            for (double y = (double)(start.func_177956_o() - radius); y <= (double)(start.func_177956_o() + radius); y += 1.0) {
                for (double z = (double)(start.func_177952_p() - radius); z <= (double)(start.func_177952_p() + radius); z += 1.0) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos.equals((Object)start) || !world.func_180495_p(pos).func_177230_c().getClass().equals(clazz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static double distanceFrom(BlockPos start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(start.func_177958_n() - end.func_177958_n(), 2.0) + Math.pow(start.func_177956_o() - end.func_177956_o(), 2.0) + Math.pow(start.func_177952_p() - end.func_177952_p(), 2.0));
    }

    public static double distanceFrom(Vector3d start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(start.field_72450_a - (double)end.func_177958_n(), 2.0) + Math.pow(start.field_72448_b - (double)end.func_177956_o(), 2.0) + Math.pow(start.field_72449_c - (double)end.func_177952_p(), 2.0));
    }

    public static double distanceFrom(Vector3d start, Vector3d end) {
        return Math.sqrt(Math.pow(start.field_72450_a - end.field_72450_a, 2.0) + Math.pow(start.field_72448_b - end.field_72448_b, 2.0) + Math.pow(start.field_72449_c - end.field_72449_c, 2.0));
    }

    public static boolean destroyBlockSafely(World world, BlockPos pos, boolean dropBlock, LivingEntity caster) {
        PlayerEntity playerEntity;
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        Object object = playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), playerEntity))) {
            return false;
        }
        world.func_180495_p(pos).func_177230_c().func_176208_a(world, pos, world.func_180495_p(pos), playerEntity);
        return world.func_175655_b(pos, dropBlock);
    }

    public static boolean destroyRespectsClaim(LivingEntity caster, World world, BlockPos pos) {
        PlayerEntity playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        return !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), playerEntity));
    }

    public static void safelyUpdateState(World world, BlockPos pos, BlockState state) {
        if (!World.func_189509_E((BlockPos)pos)) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public static void safelyUpdateState(World world, BlockPos pos) {
        BlockUtil.safelyUpdateState(world, pos, world.func_180495_p(pos));
    }

    public static boolean destroyBlockSafelyWithoutSound(World world, BlockPos pos, boolean dropBlock) {
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, null);
    }

    public static boolean destroyBlockSafelyWithoutSound(World world, BlockPos pos, boolean dropBlock, @Nullable LivingEntity caster) {
        PlayerEntity playerEntity;
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        Object object = playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), playerEntity))) {
            return false;
        }
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock);
    }

    private static boolean destroyBlockWithoutSound(World world, BlockPos pos, boolean dropBlock) {
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, null);
    }

    private static boolean destroyBlockWithoutSound(World world, BlockPos pos, boolean isMoving, @Nullable Entity entityIn) {
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.isAir((IBlockReader)world, pos)) {
            return false;
        }
        FluidState ifluidstate = world.func_204610_c(pos);
        if (isMoving) {
            TileEntity tileentity = blockstate.hasTileEntity() ? world.func_175625_s(pos) : null;
            Block.func_220054_a((BlockState)blockstate, (World)world, (BlockPos)pos, (TileEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.field_190927_a);
        }
        return world.func_180501_a(pos, ifluidstate.func_206883_i(), 3);
    }

    public static List<IItemHandler> getAdjacentInventories(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return new ArrayList<IItemHandler>();
        }
        ArrayList<IItemHandler> iInventories = new ArrayList<IItemHandler>();
        for (Direction d : Direction.values()) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(d));
            if (tileEntity == null || !tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) continue;
            iInventories.add((IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null));
        }
        return iInventories;
    }

    public static ItemStack insertItemAdjacent(World world, BlockPos pos, ItemStack stack) {
        for (IItemHandler i : BlockUtil.getAdjacentInventories(world, pos)) {
            if (stack == ItemStack.field_190927_a || stack == null) break;
            stack = ItemHandlerHelper.insertItemStacked((IItemHandler)i, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack getItemAdjacent(World world, BlockPos pos, Predicate<ItemStack> matchPredicate) {
        ItemStack stack = ItemStack.field_190927_a;
        for (IItemHandler inv : BlockUtil.getAdjacentInventories(world, pos)) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!matchPredicate.test(inv.getStackInSlot(i))) continue;
                return inv.getStackInSlot(i);
            }
        }
        return stack;
    }

    public static List<BlockPos> getLine(int x0, int y0, int x1, int y1, float wd) {
        ArrayList<BlockPos> vects = new ArrayList<BlockPos>();
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        float ed = dx + dy == 0 ? 1.0f : MathHelper.func_76129_c((float)((float)dx * (float)dx + (float)dy * (float)dy));
        wd = (wd + 1.0f) / 2.0f;
        while (true) {
            vects.add(new BlockPos(x0, 0, y0));
            int e2 = err;
            int x2 = x0;
            if (2 * e2 >= -dx) {
                e2 += dy;
                int y2 = y0;
                while ((float)e2 < ed * wd && (y1 != y2 || dx > dy)) {
                    vects.add(new BlockPos(x0, 0, y2 += sy));
                    e2 += dx;
                }
                if (x0 == x1) break;
                e2 = err;
                err -= dy;
                x0 += sx;
            }
            if (2 * e2 > dy) continue;
            e2 = dx - e2;
            while ((float)e2 < ed * wd && (x1 != x2 || dx < dy)) {
                vects.add(new BlockPos(x2 += sx, 0, y0));
                e2 += dy;
            }
            if (y0 == y1) break;
            err += dx;
            y0 += sy;
        }
        return vects;
    }

    @Nullable
    public static BlockPos scanForBlockNearPoint(World world, BlockPos point, int radiusX, int radiusY, int radiusZ, int height) {
        BlockPos closestCoords = null;
        double minDistance = Double.MAX_VALUE;
        for (int j = point.func_177956_o(); j <= point.func_177956_o() + radiusY; ++j) {
            for (int i = point.func_177958_n() - radiusX; i <= point.func_177958_n() + radiusX; ++i) {
                for (int k = point.func_177952_p() - radiusZ; k <= point.func_177952_p() + radiusZ; ++k) {
                    BlockPos tempCoords;
                    if (!BlockUtil.wontSuffocate(world, i, j, k, height) || !world.func_180495_p((tempCoords = new BlockPos(i, j, k)).func_177977_b()).func_185904_a().func_76220_a() && !world.func_180495_p(tempCoords.func_177979_c(2)).func_185904_a().func_76220_a()) continue;
                    double distance = BlockUtil.getDistanceSquared(tempCoords, point);
                    if (closestCoords != null && !(distance < minDistance)) continue;
                    closestCoords = tempCoords;
                    minDistance = distance;
                }
            }
        }
        return closestCoords;
    }

    private static boolean wontSuffocate(World world, int x, int y, int z, int height) {
        for (int dy = 0; dy < height; ++dy) {
            BlockState state = world.func_180495_p(new BlockPos(x, y + dy, z));
            if (!state.func_185904_a().func_76230_c()) continue;
            return false;
        }
        return true;
    }

    public static long getDistanceSquared(BlockPos block1, BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.func_177958_n() - (long)block2.func_177958_n();
        long result = xDiff * xDiff + (yDiff = (long)block1.func_177956_o() - (long)block2.func_177956_o()) * yDiff + (zDiff = (long)block1.func_177952_p() - (long)block2.func_177952_p()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    private BlockUtil() {
    }
}

