/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tileentity.TileEntity;

public class SpellContext {
    private boolean isCanceled;
    private Spell spell;
    @Nullable
    public LivingEntity caster;
    private int currentIndex;
    @Nullable
    public TileEntity castingTile;
    public ParticleColor.IntWrapper colors;
    private CasterType type;

    @Deprecated
    public SpellContext(List<AbstractSpellPart> spell, @Nullable LivingEntity caster) {
        this(new Spell(spell), caster);
    }

    public SpellContext(@Nonnull Spell spell, @Nullable LivingEntity caster) {
        this.spell = spell;
        this.caster = caster;
        this.isCanceled = false;
        this.currentIndex = 0;
        this.colors = ParticleUtil.defaultParticleColorWrapper();
    }

    @Nullable
    public AbstractSpellPart nextSpell() {
        ++this.currentIndex;
        AbstractSpellPart part = null;
        try {
            part = this.getSpell().recipe.get(this.currentIndex - 1);
        }
        catch (Throwable e) {
            System.out.println("=======");
            System.out.println("Invalid spell cast found! This is a bug and should be reported!");
            System.out.println(this.spell.getDisplayString());
            System.out.println("Casting player: ");
            System.out.println(this.caster);
            System.out.println("Casting tile:");
            System.out.println(this.castingTile);
            System.out.println("=======");
            e.printStackTrace();
        }
        return part;
    }

    public SpellContext resetCastCounter() {
        this.currentIndex = 0;
        this.isCanceled = false;
        return this;
    }

    public SpellContext withCastingTile(TileEntity tile) {
        this.castingTile = tile;
        return this;
    }

    public SpellContext withSpellResetCounter(Spell spell) {
        this.spell = spell;
        this.resetCastCounter();
        return this;
    }

    public SpellContext withCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        return this;
    }

    public SpellContext withColors(ParticleColor.IntWrapper colors) {
        this.colors = colors;
        return this;
    }

    public SpellContext withType(CasterType type) {
        this.type = type;
        return this;
    }

    public CasterType getType() {
        return this.type == null ? CasterType.OTHER : this.type;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean canceled) {
        this.isCanceled = canceled;
    }

    @Nonnull
    public Spell getSpell() {
        return this.spell == null ? Spell.EMPTY : this.spell;
    }

    @Nullable
    public LivingEntity getCaster() {
        return this.caster;
    }

    public static class CasterType {
        public static final CasterType RUNE = new CasterType("rune");
        public static final CasterType TURRET = new CasterType("turret");
        public static final CasterType ENTITY = new CasterType("entity");
        public static final CasterType OTHER = new CasterType("other");
        public String id;

        public CasterType(String id) {
            this.id = id;
        }
    }
}

