/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class SpellCaster
implements ISpellCaster {
    private Map<Integer, Spell> spells = new HashMap<Integer, Spell>();
    private int slot;
    ItemStack stack;
    String flavorText;
    ParticleColor.IntWrapper color = ParticleUtil.defaultParticleColorWrapper();

    private SpellCaster(ItemStack stack) {
        this.stack = stack;
        this.flavorText = "";
    }

    @Override
    @Nonnull
    public Spell getSpell() {
        return this.spells.getOrDefault(this.getCurrentSlot(), Spell.EMPTY);
    }

    @Override
    public Spell getSpell(int slot) {
        return this.spells.get(slot);
    }

    @Override
    public int getMaxSlots() {
        return 1;
    }

    @Override
    public int getCurrentSlot() {
        return this.slot;
    }

    @Override
    public void setCurrentSlot(int slot) {
        this.slot = slot;
        this.write(this.stack);
    }

    @Override
    public void setSpell(Spell spell, int slot) {
        this.spells.put(slot, spell);
        this.write(this.stack);
    }

    @Override
    public void setSpell(Spell spell) {
        this.spells.put(this.getCurrentSlot(), spell);
        this.write(this.stack);
    }

    @Override
    public void setFlavorText(String str) {
        this.flavorText = str;
        this.write(this.stack);
    }

    @Override
    public String getFlavorText() {
        return this.flavorText == null ? "" : this.flavorText;
    }

    @Override
    public void setColor(ParticleColor.IntWrapper color) {
        this.color = color;
    }

    @Override
    @Nonnull
    public ParticleColor.IntWrapper getColor() {
        return this.color == null ? ParticleUtil.defaultParticleColorWrapper() : this.color;
    }

    @Override
    public Map<Integer, Spell> getSpells() {
        return this.spells;
    }

    @Nonnull
    public static SpellCaster deserialize(ItemStack stack) {
        SpellCaster instance = new SpellCaster(stack);
        CompoundNBT tag = stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
        instance.slot = tag.func_74762_e("current_slot");
        for (int i = 0; i < instance.getMaxSlots(); ++i) {
            if (!tag.func_74764_b("spell_" + i)) continue;
            instance.getSpells().put(i, Spell.deserialize(tag.func_74779_i("spell_" + i)));
        }
        instance.color = tag.func_74779_i("color").isEmpty() ? ParticleUtil.defaultParticleColorWrapper() : ParticleColor.IntWrapper.deserialize(tag.func_74779_i("color"));
        instance.flavorText = tag.func_74779_i("flavor");
        return instance;
    }

    public void write(ItemStack stack) {
        CompoundNBT tag = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        tag.func_74768_a("current_slot", this.getCurrentSlot());
        tag.func_74768_a("max_slot", this.getMaxSlots());
        tag.func_74778_a("color", this.color.serialize());
        tag.func_74778_a("flavor", this.getFlavorText());
        int i = 0;
        for (Integer s : this.getSpells().keySet()) {
            tag.func_74778_a("spell_" + i, this.getSpells().get(s).serialize());
            ++i;
        }
        stack.func_77982_d(tag);
    }
}

