/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;

public class ShapedHelper {
    int recipeWidth;
    int recipeHeight;
    NonNullList<Ingredient> recipeItems;
    public List<List<Ingredient>> possibleRecipes;

    public ShapedHelper(ShapedRecipe recipe) {
        this.recipeHeight = recipe.getRecipeHeight();
        this.recipeWidth = recipe.getRecipeWidth();
        this.recipeItems = recipe.func_192400_c();
        this.possibleRecipes = this.getPossibleRecipes();
    }

    public List<List<Ingredient>> getPossibleRecipes() {
        ArrayList<List<Ingredient>> ingredients = new ArrayList<List<Ingredient>>();
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (!this.checkMatch(i, j, true).isEmpty()) {
                    ingredients.add(this.checkMatch(i, j, true));
                }
                if (this.checkMatch(i, j, false).isEmpty()) continue;
                ingredients.add(this.checkMatch(i, j, false));
            }
        }
        return ingredients;
    }

    private List<Ingredient> checkMatch(int width, int height, boolean p_77573_4_) {
        ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth) : (Ingredient)this.recipeItems.get(k + l * this.recipeWidth);
                }
                if (ingredient.func_193365_a().length == 0) continue;
                ingredientList.add(ingredient);
            }
        }
        return ingredientList;
    }
}

