/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.familiar;

import com.hollingsworth.arsnouveau.api.familiar.IFamiliarCap;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.capability.SerializableCapabilityProvider;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSyncFamiliars;
import com.hollingsworth.arsnouveau.setup.InjectionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class FamiliarCap
implements IFamiliarCap {
    private Set<String> ownedFamiliars = new HashSet<String>();
    private final LivingEntity livingEntity;
    @CapabilityInject(value=IFamiliarCap.class)
    public static final Capability<IFamiliarCap> FAMILIAR_CAPABILITY = (Capability)InjectionUtil.Null();
    public static final Direction DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("ars_nouveau", "familiar");

    public FamiliarCap(@Nullable LivingEntity entity) {
        this.livingEntity = entity;
    }

    @Override
    public boolean unlockFamiliar(String holderID) {
        return this.ownedFamiliars.add(holderID);
    }

    @Override
    public boolean ownsFamiliar(String holderID) {
        return this.ownedFamiliars.contains(holderID);
    }

    @Override
    public Collection<String> getUnlockedFamiliars() {
        return this.ownedFamiliars;
    }

    @Override
    public void setUnlockedFamiliars(Collection<String> familiars) {
        this.ownedFamiliars = new HashSet<String>(familiars);
    }

    @Override
    public boolean removeFamiliar(String holderID) {
        return this.ownedFamiliars.remove(holderID);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IFamiliarCap.class, (Capability.IStorage)new Capability.IStorage<IFamiliarCap>(){

            @Nullable
            public INBT writeNBT(Capability<IFamiliarCap> capability, IFamiliarCap instance, Direction side) {
                CompoundNBT tag = new CompoundNBT();
                FamiliarCap.serializeFamiliars(tag, instance);
                return tag;
            }

            public void readNBT(Capability<IFamiliarCap> capability, IFamiliarCap instance, Direction side, INBT nbt) {
                if (!(nbt instanceof CompoundNBT)) {
                    return;
                }
                CompoundNBT tag = (CompoundNBT)nbt;
                instance.setUnlockedFamiliars(NBTUtil.readStrings(tag, "fam"));
            }
        }, () -> new FamiliarCap(null));
        System.out.println("Finished Registering FamiliarCap");
    }

    public static void serializeFamiliars(CompoundNBT tag, IFamiliarCap cap) {
        NBTUtil.writeStrings(tag, "fam", cap.getUnlockedFamiliars());
    }

    public static List<String> deserializeFamiliars(CompoundNBT tag) {
        return NBTUtil.readStrings(tag, "fam");
    }

    public static LazyOptional<IFamiliarCap> getFamiliarCap(LivingEntity entity) {
        return entity.getCapability(FAMILIAR_CAPABILITY, DEFAULT_FACING);
    }

    public static ICapabilityProvider createProvider(IFamiliarCap familiarCap) {
        return new SerializableCapabilityProvider<IFamiliarCap>(FAMILIAR_CAPABILITY, DEFAULT_FACING, familiarCap);
    }

    public static void syncFamiliars(PlayerEntity player) {
        IFamiliarCap cap = (IFamiliarCap)FamiliarCap.getFamiliarCap((LivingEntity)player).orElse((Object)new FamiliarCap((LivingEntity)player));
        CompoundNBT tag = new CompoundNBT();
        FamiliarCap.serializeFamiliars(tag, cap);
        Networking.sendToPlayer(new PacketSyncFamiliars(tag), player);
    }

    @Mod.EventBusSubscriber(modid="ars_nouveau")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                FamiliarCap familiarCap = new FamiliarCap((LivingEntity)event.getObject());
                event.addCapability(ID, FamiliarCap.createProvider(familiarCap));
            }
        }

        @SubscribeEvent
        public static void playerClone(PlayerEvent.Clone event) {
            FamiliarCap.getFamiliarCap((LivingEntity)event.getOriginal()).ifPresent(oldFamiliarCap -> FamiliarCap.getFamiliarCap((LivingEntity)event.getPlayer()).ifPresent(newFamiliarCap -> {
                newFamiliarCap.setUnlockedFamiliars(oldFamiliarCap.getUnlockedFamiliars());
                FamiliarCap.syncFamiliars(event.getPlayer());
            }));
        }

        @SubscribeEvent
        public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getPlayer() instanceof ServerPlayerEntity) {
                FamiliarCap.syncFamiliars(event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
            if (event.getPlayer() instanceof ServerPlayerEntity) {
                FamiliarCap.syncFamiliars(event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
            if (event.getTarget() instanceof PlayerEntity && event.getPlayer() instanceof ServerPlayerEntity) {
                FamiliarCap.syncFamiliars(event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (event.getPlayer() instanceof ServerPlayerEntity) {
                FamiliarCap.syncFamiliars(event.getPlayer());
            }
        }
    }
}

