/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.integration;

import com.stereowalker.survive.entity.SurviveEntityStats;
import com.stereowalker.survive.util.TemperatureStats;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.comforts.common.ComfortsConfig;
import top.theillusivec4.comforts.common.block.SleepingBagBlock;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;

public class SurviveIntegration {
    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        if (ComfortsConfig.insulatedSleepingBag) {
            PlayerEntity player = evt.getPlayer();
            World world = player.field_70170_p;
            Optional maybePos = player.func_213374_dv();
            maybePos.ifPresent(pos -> {
                if (!world.field_72995_K && world.func_180495_p(pos).func_177230_c() instanceof SleepingBagBlock) {
                    CapabilitySleepData.getCapability(player).ifPresent(sleepData -> {
                        long timeSlept = world.func_72820_D() - sleepData.getSleepTime();
                        if (timeSlept > 1000L) {
                            this.warmBody((ServerPlayerEntity)player, timeSlept);
                        }
                    });
                }
            });
        }
    }

    private void warmBody(ServerPlayerEntity player, long timeSlept) {
        double currentTemp;
        TemperatureStats stats = SurviveEntityStats.getTemperatureStats((LivingEntity)player);
        double newTemp = currentTemp = stats.getTemperatureLevel();
        if (currentTemp < 37.0) {
            double warmFactor = timeSlept / 1000L;
            newTemp = (37.0 - currentTemp) * warmFactor / 10.0 + currentTemp;
        }
        stats.setTemperatureLevel((int)newTemp);
        SurviveEntityStats.setTemperatureStats((LivingEntity)player, (TemperatureStats)stats);
    }
}

