/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.IFluidBlock;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickBreakBlock
extends PieceTrick {
    public static ThreadLocal<Boolean> doingHarvestCheck = ThreadLocal.withInitial(() -> false);
    SpellParam<Vector3> position;

    public PieceTrickBreakBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 50);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        ItemStack tool = context.getHarvestTool();
        Vector3 positionVal = this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        PieceTrickBreakBlock.removeBlockWithDrops(context, context.caster, context.focalPoint.func_130014_f_(), tool, pos, true);
        return null;
    }

    public static void removeBlockWithDrops(SpellContext context, PlayerEntity player, World world, ItemStack tool, BlockPos pos, boolean particles) {
        BlockState state;
        Block block;
        if (!world.func_175667_e(pos) || context.positionBroken != null && pos.equals((Object)new BlockPos(context.positionBroken.func_216347_e().field_72450_a, context.positionBroken.func_216347_e().field_72448_b, context.positionBroken.func_216347_e().field_72449_c)) || !world.func_175660_a(player, pos)) {
            return;
        }
        if (tool.func_190926_b()) {
            tool = PsiAPI.getPlayerCAD(player);
        }
        if (!(block = (state = world.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockReader)world, pos) && !(block instanceof IFluidBlock) && state.func_185887_b((IBlockReader)world, pos) != -1.0f) {
            if (!PieceTrickBreakBlock.canHarvestBlock(state, player, world, pos, tool)) {
                return;
            }
            BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, player, world, pos, tool);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    TileEntity tile = world.func_175625_s(pos);
                    if (block.removedByPlayer(state, world, pos, player, true, world.func_204610_c(pos))) {
                        block.func_176206_d((IWorld)world, pos, state);
                        block.func_180657_a(world, player, pos, state, tile, tool);
                        if (world instanceof ServerWorld) {
                            block.func_180637_b((ServerWorld)world, pos, event.getExpToDrop());
                        }
                    }
                } else {
                    world.func_217377_a(pos, false);
                }
            }
            if (particles) {
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            }
        }
    }

    public static BlockEvent.BreakEvent createBreakEvent(BlockState state, PlayerEntity player, World world, BlockPos pos, ItemStack tool) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        if (state == null || !PieceTrickBreakBlock.canHarvestBlock(state, player, world, pos, tool)) {
            event.setExpToDrop(0);
        } else {
            int bonusLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
            int silklevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool);
            event.setExpToDrop(state.getExpDrop((IWorldReader)world, pos, bonusLevel, silklevel));
        }
        return event;
    }

    public static boolean canHarvestBlock(BlockState state, PlayerEntity player, World world, BlockPos pos, ItemStack stack) {
        boolean wasChecking = doingHarvestCheck.get();
        doingHarvestCheck.set(true);
        ItemStack oldHeldStack = player.func_184614_ca();
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)stack);
        boolean canHarvest = state.canHarvestBlock((IBlockReader)world, pos, player);
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)oldHeldStack);
        doingHarvestCheck.set(wasChecking);
        return canHarvest;
    }
}

