/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.PsiSoundHandler;

public class ItemSpellDrive
extends Item {
    private static final String TAG_SPELL = "spell";
    public static final String HAS_SPELL = "has_spell";

    public ItemSpellDrive(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @Nonnull
    public ITextComponent func_200295_i(ItemStack stack) {
        String name = super.func_200295_i(stack).getString();
        CompoundNBT cmp = stack.func_196082_o().func_74775_l(TAG_SPELL);
        String spellName = cmp.func_74779_i("spellName");
        if (spellName.isEmpty()) {
            return new StringTextComponent(name);
        }
        return new StringTextComponent(name + " (" + TextFormatting.GREEN + spellName + TextFormatting.RESET + ")");
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity playerIn = ctx.func_195999_j();
        Hand hand = ctx.func_221531_n();
        World worldIn = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileProgrammer) {
            TileProgrammer programmer = (TileProgrammer)tile;
            Spell spell = ItemSpellDrive.getSpell(stack);
            if (spell == null && programmer.canCompile()) {
                ItemSpellDrive.setSpell(stack, programmer.spell);
                if (!worldIn.field_72995_K) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, PsiSoundHandler.bulletCreate, SoundCategory.PLAYERS, 0.5f, 1.0f);
                }
                return ActionResultType.SUCCESS;
            }
            if (spell != null) {
                boolean enabled = programmer.isEnabled();
                if (enabled && !programmer.playerLock.isEmpty()) {
                    if (!programmer.playerLock.equals(playerIn.func_200200_C_().getString())) {
                        if (!worldIn.field_72995_K) {
                            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("psimisc.not_your_programmer").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
                        }
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    programmer.playerLock = playerIn.func_200200_C_().getString();
                }
                programmer.spell = spell;
                programmer.onSpellChanged();
                if (!worldIn.field_72995_K) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, PsiSoundHandler.bulletCreate, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(programmer);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (ItemSpellDrive.getSpell(itemStackIn) != null && playerIn.func_225608_bj_()) {
            if (!worldIn.field_72995_K) {
                worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), PsiSoundHandler.compileError, SoundCategory.PLAYERS, 0.5f, 1.0f);
            } else {
                playerIn.func_184609_a(hand);
            }
            ItemSpellDrive.setSpell(itemStackIn, null);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemStackIn);
    }

    public static void setSpell(ItemStack stack, Spell spell) {
        CompoundNBT cmp = new CompoundNBT();
        if (spell != null) {
            spell.writeToNBT(cmp);
            stack.func_196082_o().func_218657_a(TAG_SPELL, (INBT)cmp);
            stack.func_196082_o().func_74757_a(HAS_SPELL, true);
        } else {
            stack.func_196082_o().func_82580_o(TAG_SPELL);
            stack.func_196082_o().func_82580_o(HAS_SPELL);
        }
    }

    public static Spell getSpell(ItemStack stack) {
        CompoundNBT cmp = stack.func_196082_o().func_74775_l(TAG_SPELL);
        return Spell.createFromNBT(cmp);
    }
}

