/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability;

import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.detonator.IDetonationHandler;
import vazkii.psi.common.core.capability.CapabilityTriggerSensor;
import vazkii.psi.common.core.handler.capability.SocketWheel;
import vazkii.psi.common.core.handler.capability.SpellHolder;
import vazkii.psi.common.core.handler.capability.wrappers.SimpleProvider;

@Mod.EventBusSubscriber(modid="psi")
public class CapabilityHandler {
    private static final ResourceLocation SPELL_IMMUNE = new ResourceLocation("psi", "immune");
    private static final ResourceLocation DETONATOR = new ResourceLocation("psi", "detonator");
    public static final ResourceLocation TRIGGER_SENSOR = new ResourceLocation("psi", "trigger_sensor");

    public static void register() {
        CapabilityHandler.register(ICADData.class, CapabilityHandler::noDefault);
        CapabilityHandler.register(ISocketable.class, SocketWheel::new);
        CapabilityHandler.register(ISpellAcceptor.class, SpellHolder::new);
        CapabilityHandler.registerSingleDefault(IDetonationHandler.class, () -> {});
        CapabilityHandler.registerSingleDefault(IPsiBarDisplay.class, data -> false);
        CapabilityHandler.registerSingleDefault(ISpellImmune.class, () -> false);
    }

    private static <T> void registerSingleDefault(Class<T> clazz, T provided) {
        CapabilityHandler.register(clazz, () -> provided);
    }

    private static <T> void register(Class<T> clazz, Callable<T> provider) {
        CapabilityManager.INSTANCE.register(clazz, new CapabilityFactory(), provider);
    }

    private static <T> T noDefault() {
        throw new UnsupportedOperationException("No default instance!");
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ISpellImmune) {
            event.addCapability(SPELL_IMMUNE, new SimpleProvider<ISpellImmune>(PsiAPI.SPELL_IMMUNE_CAPABILITY, (ISpellImmune)event.getObject()));
        }
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(TRIGGER_SENSOR, (ICapabilityProvider)new CapabilityTriggerSensor((PlayerEntity)event.getObject()));
        }
        if (event.getObject() instanceof IDetonationHandler) {
            event.addCapability(DETONATOR, new SimpleProvider<IDetonationHandler>(PsiAPI.DETONATION_HANDLER_CAPABILITY, (IDetonationHandler)event.getObject()));
        }
    }

    private static class CapabilityFactory<T>
    implements Capability.IStorage<T> {
        private CapabilityFactory() {
        }

        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            if (instance instanceof INBTSerializable) {
                return ((INBTSerializable)instance).serializeNBT();
            }
            return null;
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                ((INBTSerializable)instance).deserializeNBT(nbt);
            }
        }
    }
}

