/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.patchouli;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.StringUtils;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.patchouli.PatchouliUtils;

public class SpellGridComponent
implements ICustomComponent {
    private transient int x;
    private transient int y;
    private transient boolean isDownscaled;
    private transient SpellGrid grid;
    public IVariable spell;
    public IVariable halfsize;

    public void build(int componentX, int componentY, int pageNum) {
        try {
            String spellstr = this.spell.asString("");
            if (StringUtils.func_151246_b((String)spellstr)) {
                throw new IllegalArgumentException("Spell string is missing!");
            }
            CompoundNBT cmp = JsonToNBT.func_180713_a((String)spellstr);
            Spell fromNBT = Spell.createFromNBT(cmp);
            if (fromNBT == null) {
                throw new IllegalArgumentException("Invalid spell string: " + this.spell);
            }
            this.grid = fromNBT.grid;
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Invalid spell string: " + this.spell, e);
        }
        this.isDownscaled = this.halfsize.asBoolean(false);
    }

    public void render(MatrixStack ms, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        float scale = this.isDownscaled ? 0.5f : 1.0f;
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        ms.func_227860_a_();
        ms.func_227861_a_((double)this.x, (double)this.y, 0.0);
        ms.func_227862_a_(scale, scale, scale);
        this.grid.draw(ms, (IRenderTypeBuffer)buffer, 0xF000F0);
        buffer.func_228461_a_();
        float scaledSize = 18.0f * scale;
        int scaledHoverSize = (int)(16.0f * scale);
        SpellPiece[][] gridData = this.grid.gridData;
        for (int i = 0; i < gridData.length; ++i) {
            SpellPiece[] data = gridData[i];
            for (int j = 0; j < data.length; ++j) {
                SpellPiece piece = data[j];
                if (piece == null || !context.isAreaHovered(mouseX, mouseY, (int)((float)this.x + (float)i * scaledSize), (int)((float)this.y + (float)j * scaledSize), scaledHoverSize, scaledHoverSize)) continue;
                PatchouliUtils.setPieceTooltip(context, piece);
            }
        }
        ms.func_227865_b_();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.spell = (IVariable)lookup.apply(this.spell);
        this.halfsize = (IVariable)lookup.apply(this.halfsize);
    }
}

