/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.jei.tricks;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.recipe.ITrickRecipe;
import vazkii.psi.client.jei.tricks.DrawableTAS;
import vazkii.psi.common.Psi;
import vazkii.psi.common.item.base.ModItems;

public class TrickCraftingCategory
implements IRecipeCategory<ITrickRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("psi", "trick");
    private static final int INPUT_SLOT = 0;
    private static final int CAD_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int trickX = 43;
    private static final int trickY = 24;
    private final Map<ResourceLocation, IDrawable> trickIcons = new HashMap<ResourceLocation, IDrawable>();
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable programmerHover;
    private final IGuiHelper helper;

    public TrickCraftingCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(new ResourceLocation("psi", "textures/gui/jei/trick.png"), 0, 0, 96, 41);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.psidust));
        this.programmerHover = helper.createDrawable(new ResourceLocation("psi", "textures/gui/programmer.png"), 16, 184, 16, 16);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends ITrickRecipe> getRecipeClass() {
        return ITrickRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.psi.category.trick", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ITrickRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, (List)ImmutableList.of((Object)ImmutableList.copyOf((Object[])recipe.getInput().func_193365_a()), (Object)ImmutableList.of((Object)recipe.getAssembly())));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(ITrickRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        if (recipe.getPiece() != null) {
            IDrawable trickIcon = this.trickIcons.computeIfAbsent(recipe.getPiece().registryKey, key -> {
                RenderMaterial mat = ClientPsiAPI.getSpellPieceMaterial(key);
                if (mat == null) {
                    Psi.logger.warn("Not rendering complex (or missing) render for {}", key);
                    return this.helper.createBlankDrawable(16, 16);
                }
                return new DrawableTAS(mat.func_229314_c_());
            });
            trickIcon.draw(matrixStack, 43, 24);
            if (TrickCraftingCategory.onTrick(mouseX, mouseY)) {
                this.programmerHover.draw(matrixStack, 43, 24);
            }
        }
    }

    @Nonnull
    public List<ITextComponent> getTooltipStrings(ITrickRecipe recipe, double mouseX, double mouseY) {
        if (recipe.getPiece() != null && TrickCraftingCategory.onTrick(mouseX, mouseY)) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            recipe.getPiece().getTooltip(tooltip);
            return tooltip;
        }
        return Collections.emptyList();
    }

    private static boolean onTrick(double mouseX, double mouseY) {
        return mouseX >= 43.0 && mouseX <= 59.0 && mouseY >= 24.0 && mouseY <= 40.0;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ITrickRecipe recipe, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 5);
        recipeLayout.getItemStacks().init(1, true, 21, 23);
        recipeLayout.getItemStacks().init(2, false, 73, 5);
        recipeLayout.getItemStacks().set(ingredients);
    }
}

