/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.jei.crafting;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.crafting.recipe.DriveDuplicateRecipe;
import vazkii.psi.common.item.ItemSpellDrive;
import vazkii.psi.common.item.base.ModItems;

public class DriveDuplicateExtension
implements ICustomCraftingCategoryExtension {
    private final DriveDuplicateRecipe recipe;
    private final List<Ingredient> inputs;

    public DriveDuplicateExtension(DriveDuplicateRecipe recipe) {
        this.recipe = recipe;
        Ingredient drive = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.spellDrive});
        this.inputs = ImmutableList.of((Object)drive, (Object)drive);
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputIngredients(this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)ModItems.spellDrive));
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        Spell spell;
        ItemStack stack;
        recipeLayout.setShapeless();
        recipeLayout.getItemStacks().set(ingredients);
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        if (focus != null && (stack = (ItemStack)focus.getValue()).func_77973_b() instanceof ItemSpellDrive && (spell = ItemSpellDrive.getSpell(stack)) != null) {
            ItemStack drive = new ItemStack((IItemProvider)ModItems.spellDrive);
            ItemSpellDrive.setSpell(drive, spell);
            recipeLayout.getItemStacks().set(0, drive);
            recipeLayout.getItemStacks().set(1, drive);
        }
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.func_199560_c();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a((String)"jei.psi.spell_copy", (Object[])new Object[0]), 57.0f, 46.0f, 0x808080);
        RenderSystem.enableAlphaTest();
    }
}

