/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.internal;

import java.util.LinkedHashSet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public final class MathHelper {
    public static float pointDistancePlane(double x1, double y1, double x2, double y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    public static double pointDistanceSpace(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0));
    }

    public static LinkedHashSet<BlockPos> getBlocksAlongRay(Vector3d origin, Vector3d end) {
        return MathHelper.getBlocksAlongRay(origin, end, Integer.MAX_VALUE);
    }

    public static LinkedHashSet<BlockPos> getBlocksAlongRay(Vector3d origin, Vector3d end, int maxBlocks) {
        LinkedHashSet<BlockPos> positions = new LinkedHashSet<BlockPos>();
        if (maxBlocks == 0) {
            return positions;
        }
        if (origin.equals((Object)end)) {
            positions.add(new BlockPos(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c));
        } else {
            double endX = end.field_72450_a;
            double endY = end.field_72448_b;
            double endZ = end.field_72449_c;
            double originX = origin.field_72450_a;
            double originY = origin.field_72448_b;
            double originZ = origin.field_72449_c;
            int blockX = net.minecraft.util.math.MathHelper.func_76128_c((double)originX);
            int blockY = net.minecraft.util.math.MathHelper.func_76128_c((double)originY);
            int blockZ = net.minecraft.util.math.MathHelper.func_76128_c((double)originZ);
            BlockPos.Mutable blockPos = new BlockPos.Mutable(blockX, blockY, blockZ);
            positions.add(blockPos.func_185334_h());
            double lengthX = endX - originX;
            double lengthY = endY - originY;
            double lengthZ = endZ - originZ;
            int signumX = net.minecraft.util.math.MathHelper.func_219802_k((double)lengthX);
            int signumY = net.minecraft.util.math.MathHelper.func_219802_k((double)lengthY);
            int signumZ = net.minecraft.util.math.MathHelper.func_219802_k((double)lengthZ);
            double stepSizeX = signumX == 0 ? Double.MAX_VALUE : (double)signumX / lengthX;
            double stepSizeY = signumY == 0 ? Double.MAX_VALUE : (double)signumY / lengthY;
            double stepSizeZ = signumZ == 0 ? Double.MAX_VALUE : (double)signumZ / lengthZ;
            double totalStepsX = stepSizeX * (signumX > 0 ? 1.0 - net.minecraft.util.math.MathHelper.func_181162_h((double)originX) : net.minecraft.util.math.MathHelper.func_181162_h((double)originX));
            double totalStepsY = stepSizeY * (signumY > 0 ? 1.0 - net.minecraft.util.math.MathHelper.func_181162_h((double)originY) : net.minecraft.util.math.MathHelper.func_181162_h((double)originY));
            double totalStepsZ = stepSizeZ * (signumZ > 0 ? 1.0 - net.minecraft.util.math.MathHelper.func_181162_h((double)originZ) : net.minecraft.util.math.MathHelper.func_181162_h((double)originZ));
            while ((totalStepsX <= 1.0 || totalStepsY <= 1.0 || totalStepsZ <= 1.0) && positions.size() != maxBlocks) {
                if (totalStepsX < totalStepsY) {
                    if (totalStepsX < totalStepsZ) {
                        blockX += signumX;
                        totalStepsX += stepSizeX;
                    } else {
                        blockZ += signumZ;
                        totalStepsZ += stepSizeZ;
                    }
                } else if (totalStepsY < totalStepsZ) {
                    blockY += signumY;
                    totalStepsY += stepSizeY;
                } else {
                    blockZ += signumZ;
                    totalStepsZ += stepSizeZ;
                }
                blockPos.func_181079_c(blockX, blockY, blockZ);
                positions.add(blockPos.func_185334_h());
            }
        }
        return positions;
    }
}

