/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.spell;

import elucent.eidolon.deity.Deities;
import elucent.eidolon.spell.AnimalSacrificeSpell;
import elucent.eidolon.spell.DarkTouchSpell;
import elucent.eidolon.spell.PrayerSpell;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.spell.Signs;
import elucent.eidolon.spell.Spell;
import elucent.eidolon.spell.VillagerSacrificeSpell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class Spells {
    static List<Spell> spells = new ArrayList<Spell>();
    static Map<ResourceLocation, Spell> spellMap = new HashMap<ResourceLocation, Spell>();
    public static Spell DARK_PRAYER = Spells.register(new PrayerSpell(new ResourceLocation("eidolon", "dark_prayer"), Deities.DARK_DEITY, Signs.WICKED_SIGN, Signs.WICKED_SIGN, Signs.WICKED_SIGN));
    public static Spell DARK_ANIMAL_SACRIFICE = Spells.register(new AnimalSacrificeSpell(new ResourceLocation("eidolon", "dark_animal_sacrifice"), Deities.DARK_DEITY, Signs.WICKED_SIGN, Signs.BLOOD_SIGN, Signs.WICKED_SIGN));
    public static Spell DARK_TOUCH = Spells.register(new DarkTouchSpell(new ResourceLocation("eidolon", "dark_touch"), Signs.WICKED_SIGN, Signs.SOUL_SIGN, Signs.WICKED_SIGN, Signs.SOUL_SIGN));
    public static Spell DARK_VILLAGER_SACRIFICE = Spells.register(new VillagerSacrificeSpell(new ResourceLocation("eidolon", "dark_villager_sacrifice"), Deities.DARK_DEITY, Signs.BLOOD_SIGN, Signs.WICKED_SIGN, Signs.BLOOD_SIGN, Signs.SOUL_SIGN));

    public static Spell find(ResourceLocation loc) {
        return spellMap.getOrDefault(loc, null);
    }

    public static Spell find(List<Sign> signs) {
        for (Spell spell : spells) {
            if (!spell.matches(signs)) continue;
            return spell;
        }
        return null;
    }

    public static Spell register(Spell spell) {
        spells.add(spell);
        spellMap.put(spell.getRegistryName(), spell);
        return spell;
    }

    public static List<Spell> getSpells() {
        return spells;
    }
}

